/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.matrixset;

import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDao;
import mil.nga.geopackage.srs.SpatialReferenceSystemDao;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;

public class TileMatrixSetDao
extends GeoPackageDao<TileMatrixSet, String> {
    public static TileMatrixSetDao create(GeoPackageCore geoPackage) {
        return TileMatrixSetDao.create(geoPackage.getDatabase());
    }

    public static TileMatrixSetDao create(GeoPackageCoreConnection db) {
        return (TileMatrixSetDao)((Object)GeoPackageDao.createDao(db, TileMatrixSet.class));
    }

    public TileMatrixSetDao(ConnectionSource connectionSource, Class<TileMatrixSet> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public List<String> getTileTables() throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        List tileMatrixSets = this.queryForAll();
        for (TileMatrixSet tileMatrixSet : tileMatrixSets) {
            tableNames.add(tileMatrixSet.getTableName());
        }
        return tableNames;
    }

    public TileMatrixSet queryForId(String id) throws SQLException {
        TileMatrixSet tileMatrixSet = (TileMatrixSet)super.queryForId((Object)id);
        if (tileMatrixSet != null) {
            this.updateSRS(tileMatrixSet);
        }
        return tileMatrixSet;
    }

    public List<TileMatrixSet> queryForEq(String fieldName, Object value) throws SQLException {
        List tileMatrixSets = super.queryForEq(fieldName, value);
        if (tileMatrixSets != null) {
            for (TileMatrixSet tileMatrixSet : tileMatrixSets) {
                this.updateSRS(tileMatrixSet);
            }
        }
        return tileMatrixSets;
    }

    private void updateSRS(TileMatrixSet tileMatrixSet) {
        SpatialReferenceSystemDao.setExtensionValues(this.db, tileMatrixSet.getSrs());
        Contents contents = tileMatrixSet.getContents();
        if (contents != null) {
            SpatialReferenceSystemDao.setExtensionValues(this.db, contents.getSrs());
        }
    }
}

