/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.encoding;

import com.linecorp.armeria.common.ContentTooLargeException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.encoding.StreamDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.DecompressionException;

class AbstractStreamDecoder
implements StreamDecoder {
    private final EmbeddedChannel decoder;
    private final int maxLength;
    private int decodedLength;

    protected AbstractStreamDecoder(ChannelHandler handler, ByteBufAllocator alloc, int maxLength) {
        this.decoder = new EmbeddedChannel(false, new ChannelHandler[]{handler});
        this.decoder.config().setAllocator(alloc);
        this.maxLength = maxLength;
    }

    @Override
    public HttpData decode(HttpData obj) {
        block2: {
            try {
                this.decoder.writeInbound(new Object[]{obj.byteBuf()});
            }
            catch (DecompressionException ex) {
                String message = ex.getMessage();
                if (message == null || !message.startsWith("Decompression buffer has reached maximum size:")) break block2;
                throw ContentTooLargeException.builder().maxContentLength(this.maxLength).cause(ex).build();
            }
        }
        return this.fetchDecoderOutput();
    }

    @Override
    public HttpData finish() {
        if (this.decoder.finish()) {
            return this.fetchDecoderOutput();
        }
        return HttpData.empty();
    }

    @Override
    public int maxLength() {
        return this.maxLength;
    }

    protected HttpData fetchDecoderOutput() {
        ByteBuf buf;
        ByteBuf decoded = null;
        while ((buf = (ByteBuf)this.decoder.readInbound()) != null) {
            if (!buf.isReadable()) {
                buf.release();
                continue;
            }
            this.maybeCheckOverflow(decoded, buf);
            if (decoded == null) {
                decoded = buf;
                continue;
            }
            try {
                decoded.writeBytes(buf);
            }
            finally {
                buf.release();
            }
        }
        if (decoded == null) {
            return HttpData.empty();
        }
        return HttpData.wrap(decoded);
    }

    private void maybeCheckOverflow(@Nullable ByteBuf decoded, ByteBuf newBuf) {
        if (this.maxLength <= 0 || this.maxLength == Integer.MAX_VALUE) {
            return;
        }
        this.decodedLength += newBuf.readableBytes();
        if (this.decodedLength > this.maxLength) {
            if (decoded != null) {
                decoded.release();
            }
            newBuf.release();
            throw ContentTooLargeException.builder().maxContentLength(this.maxLength).transferred(this.decodedLength).build();
        }
    }
}

