/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import com.linecorp.armeria.internal.common.CancellationScheduler;
import com.linecorp.armeria.internal.common.HttpHeadersUtil;
import com.linecorp.armeria.internal.server.DefaultServiceRequestContext;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.DecodedHttpRequest;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerHttpObjectEncoder;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.TransientServiceOption;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.CompletableFuture;

abstract class AbstractHttpResponseHandler {
    static final AggregatedHttpResponse internalServerErrorResponse = AggregatedHttpResponse.of(HttpStatus.INTERNAL_SERVER_ERROR);
    final ChannelHandlerContext ctx;
    final ServerHttpObjectEncoder responseEncoder;
    final DefaultServiceRequestContext reqCtx;
    final DecodedHttpRequest req;
    private final CompletableFuture<Void> completionFuture;
    private boolean isComplete;
    private boolean needsDisconnection;

    AbstractHttpResponseHandler(ChannelHandlerContext ctx, ServerHttpObjectEncoder responseEncoder, DefaultServiceRequestContext reqCtx, DecodedHttpRequest req, CompletableFuture<Void> completionFuture) {
        this.ctx = ctx;
        this.responseEncoder = responseEncoder;
        this.reqCtx = reqCtx;
        this.req = req;
        this.completionFuture = completionFuture;
    }

    boolean isDone() {
        return this.isComplete;
    }

    void disconnectWhenFinished() {
        this.needsDisconnection = true;
        this.responseEncoder.keepAliveHandler().disconnectWhenFinished();
    }

    final boolean tryComplete(@Nullable Throwable cause) {
        if (this.isComplete) {
            return false;
        }
        this.isComplete = true;
        if (cause == null) {
            this.completionFuture.complete(null);
        } else {
            this.completionFuture.completeExceptionally(cause);
        }
        if (this.needsDisconnection) {
            this.ctx.channel().close();
        }
        return true;
    }

    abstract void fail(Throwable var1);

    final boolean failIfStreamOrSessionClosed() {
        if (!this.isWritable()) {
            Throwable cause = null;
            RequestLog requestLog = this.reqCtx.log().getIfAvailable(RequestLogProperty.RESPONSE_CAUSE);
            if (requestLog != null) {
                cause = requestLog.responseCause();
            }
            if (cause == null) {
                cause = this.reqCtx.sessionProtocol().isMultiplex() ? ClosedStreamException.get() : ClosedSessionException.get();
            }
            this.fail(cause);
            return true;
        }
        return false;
    }

    final boolean isWritable() {
        return this.responseEncoder.isWritable(this.req.id(), this.req.streamId());
    }

    final ChannelFuture writeAggregatedHttpResponse(AggregatedHttpResponse res) {
        boolean contentEmpty;
        int id = this.req.id();
        int streamId = this.req.streamId();
        ServerConfig config = this.reqCtx.config().server().config();
        ResponseHeaders headers = HttpHeadersUtil.mergeResponseHeaders(res.headers(), this.reqCtx.additionalResponseHeaders(), this.reqCtx.config().defaultHeaders(), config.isServerHeaderEnabled(), config.isDateHeaderEnabled());
        String connectionOption = headers.get((CharSequence)HttpHeaderNames.CONNECTION);
        if (HttpHeadersUtil.CLOSE_STRING.equalsIgnoreCase(connectionOption)) {
            this.disconnectWhenFinished();
        }
        HttpData content = res.content();
        content.touch(this.reqCtx);
        assert (!res.status().isContentAlwaysEmpty() || content.isEmpty());
        if (content.isEmpty()) {
            contentEmpty = true;
        } else if (this.req.method() == HttpMethod.HEAD) {
            contentEmpty = true;
            content.close();
        } else {
            contentEmpty = false;
        }
        HttpHeaders trailers = HttpHeadersUtil.mergeTrailers(res.trailers(), this.reqCtx.additionalResponseTrailers());
        boolean trailersEmpty = trailers.isEmpty();
        if (this.reqCtx.sessionProtocol().isMultiplex() && !contentEmpty && headers.contentLength() == -1L) {
            headers = headers.toBuilder().contentLength(content.length()).build();
        }
        HttpMethod method = this.reqCtx.method();
        if (!res.informationals().isEmpty()) {
            for (ResponseHeaders informational : res.informationals()) {
                this.responseEncoder.writeHeaders(id, streamId, informational, false, trailersEmpty, method);
            }
        }
        this.logBuilder().responseHeaders(headers);
        ChannelFuture future = this.responseEncoder.writeHeaders(id, streamId, headers, contentEmpty && trailersEmpty, trailersEmpty, method);
        if (!contentEmpty) {
            this.logBuilder().increaseResponseLength(content);
            future = this.responseEncoder.writeData(id, streamId, content, trailersEmpty);
        }
        if (!trailersEmpty) {
            this.logBuilder().responseTrailers(trailers);
            future = this.responseEncoder.writeTrailers(id, streamId, trailers);
        }
        return future;
    }

    final CompletableFuture<AggregatedHttpResponse> toAggregatedHttpResponse(HttpResponseException cause) {
        return cause.httpResponse().aggregate(this.ctx.executor());
    }

    final AggregatedHttpResponse toAggregatedHttpResponse(HttpStatusException cause) {
        HttpStatus status = cause.httpStatus();
        Throwable cause0 = MoreObjects.firstNonNull(cause.getCause(), cause);
        ServiceConfig serviceConfig = this.reqCtx.config();
        AggregatedHttpResponse response = serviceConfig.errorHandler().renderStatus(serviceConfig, this.req.headers(), status, null, cause0);
        assert (response != null);
        return response;
    }

    final void endLogRequestAndResponse(@Nullable Throwable cause) {
        if (cause != null) {
            this.logBuilder().endRequest(cause);
            this.logBuilder().endResponse(cause);
        } else {
            this.logBuilder().endRequest();
            this.logBuilder().endResponse();
        }
    }

    final void maybeWriteAccessLog() {
        ServiceConfig config = this.reqCtx.config();
        if (config.transientServiceOptions().contains((Object)TransientServiceOption.WITH_ACCESS_LOGGING)) {
            this.reqCtx.log().whenComplete().thenAccept(config.accessLogWriter()::log);
        }
    }

    final void scheduleTimeout() {
        this.reqCtx.requestCancellationScheduler().start(this.newCancellationTask());
    }

    final void clearTimeout() {
        this.reqCtx.requestCancellationScheduler().clearTimeout(false);
    }

    final CancellationScheduler.CancellationTask newCancellationTask() {
        return new CancellationScheduler.CancellationTask(){

            @Override
            public boolean canSchedule() {
                return !AbstractHttpResponseHandler.this.isDone();
            }

            @Override
            public void run(Throwable cause) {
                assert (!AbstractHttpResponseHandler.this.isDone());
                if (cause instanceof ClosedStreamException) {
                    AbstractHttpResponseHandler.this.fail(cause);
                } else {
                    AbstractHttpResponseHandler.this.req.abortResponse(cause, false);
                }
            }
        };
    }

    final HttpService service() {
        return this.reqCtx.config().service();
    }

    final RequestLogBuilder logBuilder() {
        return this.reqCtx.logBuilder();
    }
}

