/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.annotation;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.sse.ServerSentEvent;
import com.linecorp.armeria.internal.server.annotation.ClassUtil;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.streaming.ServerSentEvents;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public final class ServerSentEventResponseConverterFunction
implements ResponseConverterFunction {
    @Override
    public Boolean isResponseStreaming(Type returnType, @Nullable MediaType contentType) {
        Class<?> clazz = ClassUtil.typeToClass(ClassUtil.unwrapUnaryAsyncType(returnType));
        if (clazz == null) {
            return null;
        }
        if (contentType != null && contentType.is(MediaType.EVENT_STREAM)) {
            return Publisher.class.isAssignableFrom(clazz) || Stream.class.isAssignableFrom(clazz);
        }
        if (ServerSentEvent.class.isAssignableFrom(clazz)) {
            return false;
        }
        return null;
    }

    @Override
    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) throws Exception {
        MediaType contentType = headers.contentType();
        if (contentType != null && contentType.is(MediaType.EVENT_STREAM)) {
            if (result instanceof Publisher) {
                return ServerSentEvents.fromPublisher(headers, (Publisher)result, trailers, ServerSentEventResponseConverterFunction::toSse);
            }
            if (result instanceof Stream) {
                return ServerSentEvents.fromStream(headers, (Stream)result, trailers, ctx.blockingTaskExecutor(), ServerSentEventResponseConverterFunction::toSse);
            }
            return ServerSentEvents.fromEvent(headers, ServerSentEventResponseConverterFunction.toSse(result), trailers);
        }
        if (result instanceof ServerSentEvent) {
            return ServerSentEvents.fromEvent(headers, (ServerSentEvent)result, trailers);
        }
        return (HttpResponse)ResponseConverterFunction.fallthrough();
    }

    private static ServerSentEvent toSse(@Nullable Object content) {
        if (content == null) {
            return ServerSentEvent.empty();
        }
        if (content instanceof ServerSentEvent) {
            return (ServerSentEvent)content;
        }
        return ServerSentEvent.ofData(String.valueOf(content));
    }
}

