/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import com.linecorp.armeria.server.docs.DescriptionInfo;
import com.linecorp.armeria.server.docs.DescriptiveTypeInfo;
import com.linecorp.armeria.server.docs.DescriptiveTypeSignature;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.ServiceInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@UnstableApi
public final class ExceptionInfo
implements DescriptiveTypeInfo {
    private final String name;
    private final List<FieldInfo> fields;
    private final DescriptionInfo descriptionInfo;

    public ExceptionInfo(String name, Iterable<FieldInfo> fields) {
        this(name, fields, DescriptionInfo.empty());
    }

    public ExceptionInfo(String name, Iterable<FieldInfo> fields, DescriptionInfo descriptionInfo) {
        this.name = Objects.requireNonNull(name, "name");
        this.fields = ImmutableList.copyOf(Objects.requireNonNull(fields, "fields"));
        this.descriptionInfo = Objects.requireNonNull(descriptionInfo, "descriptionInfo");
    }

    @Override
    public String name() {
        return this.name;
    }

    @JsonProperty
    public List<FieldInfo> fields() {
        return this.fields;
    }

    public ExceptionInfo withFields(Iterable<FieldInfo> fields) {
        Objects.requireNonNull(fields, "fields");
        if (fields.equals(this.fields)) {
            return this;
        }
        return new ExceptionInfo(this.name, fields, this.descriptionInfo);
    }

    @Override
    public DescriptionInfo descriptionInfo() {
        return this.descriptionInfo;
    }

    public ExceptionInfo withDescriptionInfo(DescriptionInfo descriptionInfo) {
        Objects.requireNonNull(descriptionInfo, "descriptionInfo");
        if (descriptionInfo.equals(this.descriptionInfo)) {
            return this;
        }
        return new ExceptionInfo(this.name, this.fields, descriptionInfo);
    }

    @Override
    public Set<DescriptiveTypeSignature> findDescriptiveTypes() {
        HashSet collectedDescriptiveTypes = new HashSet();
        this.fields().forEach(f -> ServiceInfo.findDescriptiveTypes(collectedDescriptiveTypes, f.typeSignature()));
        return ImmutableSortedSet.copyOf(Comparator.comparing(TypeSignature::name), collectedDescriptiveTypes);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExceptionInfo)) {
            return false;
        }
        ExceptionInfo that = (ExceptionInfo)o;
        return this.name.equals(that.name) && this.fields.equals(that.fields) && this.descriptionInfo.equals(that.descriptionInfo);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fields, this.descriptionInfo);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("fields", this.fields).add("descriptionInfo", this.descriptionInfo).toString();
    }
}

