/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.map;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.annotation.JacksonResponseConverterFunction;
import com.linecorp.armeria.server.cors.CorsService;
import com.linecorp.armeria.server.docs.DocService;
import com.linecorp.armeria.server.file.FileService;
import com.linecorp.armeria.server.file.HttpFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.config.ConfigReader;
import org.apache.baremaps.server.ChangeResource;
import org.apache.baremaps.server.StyleResource;
import org.apache.baremaps.server.TileResource;
import org.apache.baremaps.server.TilesetResource;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.postgres.PostgresTileStore;
import org.apache.baremaps.utils.ObjectMapperUtils;
import org.apache.baremaps.utils.PostgresUtils;
import org.apache.baremaps.vectortile.style.Style;
import org.apache.baremaps.vectortile.tileset.Tileset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="dev", description={"Start a development server with live reload."})
public class Dev
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Dev.class);
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--cache"}, paramLabel="CACHE", description={"The caffeine cache directive."})
    private String cache = "";
    @CommandLine.Option(names={"--tileset"}, paramLabel="TILESET", description={"The tileset file."}, required=true)
    private Path tilesetPath;
    @CommandLine.Option(names={"--style"}, paramLabel="STYLE", description={"The style file."}, required=true)
    private Path stylePath;
    @CommandLine.Option(names={"--assets"}, paramLabel="ASSETS", description={"The assets directory."}, required=false)
    private Path assetsPath;
    @CommandLine.Option(names={"--host"}, paramLabel="HOST", description={"The host of the server."})
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        ConfigReader configReader = new ConfigReader();
        ObjectMapper objectMapper = ObjectMapperUtils.objectMapper();
        Tileset tileset = (Tileset)objectMapper.readValue(configReader.read(this.tilesetPath), Tileset.class);
        DataSource datasource = PostgresUtils.createDataSourceFromObject((Object)tileset.getDatabase());
        Supplier<Tileset> tilesetSupplier = () -> {
            try {
                String config = configReader.read(this.tilesetPath);
                return (Tileset)objectMapper.readValue(config, Tileset.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        Supplier<TileStore> tileStoreSupplier = () -> {
            Tileset tileJSON = (Tileset)tilesetSupplier.get();
            return new PostgresTileStore(datasource, tileJSON);
        };
        Supplier<Style> styleSupplier = () -> {
            try {
                String config = configReader.read(this.stylePath);
                return (Style)objectMapper.readValue(config, Style.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        ServerBuilder serverBuilder = Server.builder();
        serverBuilder.http(this.port);
        JacksonResponseConverterFunction jsonResponseConverter = new JacksonResponseConverterFunction(objectMapper);
        serverBuilder.annotatedService((Object)new ChangeResource(this.tilesetPath, this.stylePath), new Object[]{jsonResponseConverter});
        serverBuilder.annotatedService((Object)new TileResource(tileStoreSupplier), new Object[]{jsonResponseConverter});
        serverBuilder.annotatedService((Object)new StyleResource(styleSupplier), new Object[]{jsonResponseConverter});
        serverBuilder.annotatedService((Object)new TilesetResource(tilesetSupplier), new Object[]{jsonResponseConverter});
        HttpFile index = HttpFile.of((ClassLoader)ClassLoader.getSystemClassLoader(), (String)"/static/viewer.html");
        serverBuilder.service("/", index.asService());
        serverBuilder.serviceUnder("/", (HttpService)FileService.of((ClassLoader)ClassLoader.getSystemClassLoader(), (String)"/static"));
        if (this.assetsPath != null) {
            serverBuilder.serviceUnder("/assets", (HttpService)FileService.of((Path)this.assetsPath));
        }
        serverBuilder.decorator(CorsService.builderForAnyOrigin().allowRequestMethods(new HttpMethod[]{HttpMethod.POST, HttpMethod.GET, HttpMethod.PUT}).allowRequestHeaders(new CharSequence[]{"Origin", "Content-Type", "Accept"}).newDecorator());
        serverBuilder.serviceUnder("/docs", (HttpService)new DocService());
        serverBuilder.disableServerHeader();
        serverBuilder.disableDateHeader();
        Server server = serverBuilder.build();
        CompletableFuture startFuture = server.start();
        startFuture.join();
        CompletableFuture shutdownFuture = server.closeOnJvmShutdown();
        shutdownFuture.join();
        return 0;
    }
}

