/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.data.type.DataType;

public class LongListDataType
implements DataType<List<Long>> {
    @Override
    public int size(List<Long> values) {
        return 4 + values.size() * 8;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, List<Long> values) {
        buffer.putInt(position, this.size(values));
        int p = position + 4;
        for (long value : values) {
            buffer.putLong(p, value);
            p += 8;
        }
    }

    @Override
    public List<Long> read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        int length = (size - 4) / 8;
        ArrayList<Long> values = new ArrayList<Long>(length);
        for (int index = 0; index < length; ++index) {
            values.add(buffer.getLong(position + 4 + index * 8));
        }
        return values;
    }
}

