/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import java.util.Collection;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.StringBuilders;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;

public final class VerticalDatumTypes
implements CodeList.Filter {
    public static final VerticalDatumType ELLIPSOIDAL = VerticalDatumType.valueOf((String)"ELLIPSOIDAL");
    public static final VerticalDatumType ORTHOMETRIC = VerticalDatumType.valueOf((String)"ORTHOMETRIC");
    private static final VerticalDatumType[] TYPES = new VerticalDatumType[7];
    private static final short[] LEGACY_CODES = new short[Math.max(ELLIPSOIDAL.ordinal(), ORTHOMETRIC.ordinal()) + 1];
    private final StringBuilder datum;

    public static VerticalDatumType fromLegacy(int code) {
        return (code -= 2000) >= 0 && code < TYPES.length ? TYPES[code] : null;
    }

    public static int toLegacy(VerticalDatumType type) {
        int ordinal;
        if (type != null && (ordinal = type.ordinal()) >= 0 && ordinal < LEGACY_CODES.length) {
            return LEGACY_CODES[ordinal];
        }
        return 0;
    }

    public static VerticalDatumType guess(String name, Collection<? extends GenericName> aliases, CoordinateSystemAxis axis) {
        VerticalDatumType type = VerticalDatumTypes.guess(name);
        if (type != null) {
            return type;
        }
        if (aliases != null) {
            for (GenericName genericName : aliases) {
                type = VerticalDatumTypes.guess(genericName.tip().toString());
                if (type == null) continue;
                return type;
            }
        }
        if (axis != null) {
            Unit unit = axis.getUnit();
            if (Units.isLinear((Unit)unit)) {
                String string = axis.getAbbreviation();
                if (string.length() == 1) {
                    AxisDirection dir = AxisDirection.UP;
                    switch (string.charAt(0)) {
                        case 'h': {
                            type = ELLIPSOIDAL;
                            break;
                        }
                        case 'H': {
                            type = VerticalDatumType.GEOIDAL;
                            break;
                        }
                        case 'D': {
                            type = VerticalDatumType.DEPTH;
                            dir = AxisDirection.DOWN;
                            break;
                        }
                        default: {
                            return VerticalDatumType.OTHER_SURFACE;
                        }
                    }
                    if (dir.equals((Object)axis.getDirection())) {
                        return type;
                    }
                }
            } else if (Units.isPressure((Unit)unit)) {
                return VerticalDatumType.BAROMETRIC;
            }
        }
        return VerticalDatumType.OTHER_SURFACE;
    }

    private static VerticalDatumType guess(String name) {
        if (name != null) {
            int c;
            if (CharSequences.equalsFiltered((CharSequence)"Mean Sea Level", (CharSequence)name, (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)true)) {
                return VerticalDatumType.GEOIDAL;
            }
            for (int i = 0; i < name.length(); i += Character.charCount(c)) {
                c = name.codePointAt(i);
                if (!Character.isLetter(c)) continue;
                return (VerticalDatumType)CodeList.valueOf(VerticalDatumType.class, (CodeList.Filter)new VerticalDatumTypes(name));
            }
        }
        return null;
    }

    private VerticalDatumTypes(String name) {
        int c;
        int length = name.length();
        this.datum = new StringBuilder(length);
        for (int i = 0; i < length; i += Character.charCount(c)) {
            c = name.codePointAt(i);
            this.datum.appendCodePoint(Character.toUpperCase(c));
        }
        StringBuilders.toASCII((StringBuilder)this.datum);
    }

    public boolean accept(CodeList<?> code) {
        int i = this.datum.indexOf(code.name());
        return i == 0 || i >= 0 && Character.isWhitespace(this.datum.codePointBefore(i));
    }

    public String codename() {
        return null;
    }

    static {
        block8: for (int code = 2000; code <= 2006; code = (int)((short)(code + 1))) {
            VerticalDatumType type;
            switch (code) {
                case 2000: {
                    type = VerticalDatumType.OTHER_SURFACE;
                    break;
                }
                case 2001: {
                    type = ORTHOMETRIC;
                    break;
                }
                case 2002: {
                    type = ELLIPSOIDAL;
                    break;
                }
                case 2003: {
                    type = VerticalDatumType.BAROMETRIC;
                    break;
                }
                case 2005: {
                    type = VerticalDatumType.GEOIDAL;
                    break;
                }
                case 2006: {
                    type = VerticalDatumType.DEPTH;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            VerticalDatumTypes.TYPES[code - 2000] = type;
            VerticalDatumTypes.LEGACY_CODES[type.ordinal()] = code;
        }
    }
}

