/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.utils;

import java.io.File;
import java.nio.file.Path;
import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public final class FileUtils {
    private FileUtils() {
    }

    public static boolean fileNotModified(long recordedFileContentLength, Instant recordedFileLastModified, Path path) {
        File file = path.toFile();
        Instant fileLastModified = Instant.ofEpochMilli(file.lastModified());
        return fileLastModified.equals(recordedFileLastModified) && recordedFileContentLength == file.length();
    }
}

