/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import org.apache.sis.util.LocalizedException;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.InternationalString;

final class MetadataVisitorException
extends BackingStoreException
implements LocalizedException {
    private static final long serialVersionUID = 3779183393705626697L;
    private final String[] propertyPath;

    public MetadataVisitorException(String[] path, Class<?> type, Exception cause) {
        super(type.getSimpleName(), (Throwable)cause);
        this.propertyPath = path;
    }

    public String getMessage() {
        return this.getInternationalMessage().toString();
    }

    public InternationalString getInternationalMessage() {
        short key = 152;
        int count = 2;
        Object location = super.getMessage();
        int pathLength = this.propertyPath.length;
        if (pathLength != 0) {
            location = (String)location + "." + this.propertyPath[--pathLength];
            if (pathLength != 0) {
                key = 184;
                count = 3;
            }
        }
        Throwable cause = this.getCause();
        Object message = null;
        if (cause instanceof LocalizedException) {
            message = ((LocalizedException)cause).getInternationalMessage();
        }
        if (message == null && (message = cause.getLocalizedMessage()) == null) {
            message = cause.getClass();
        }
        Object[] arguments = new Object[count];
        arguments[--count] = message;
        arguments[--count] = location;
        if (count != 0) {
            arguments[0] = String.join((CharSequence)".", (Iterable<? extends CharSequence>)UnmodifiableArrayList.wrap((Object[])this.propertyPath, (int)0, (int)pathLength));
        }
        return Errors.formatInternational((short)key, (Object[])arguments);
    }
}

