/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.ExtensionsDao;

@DatabaseTable(tableName="gpkg_extensions", daoClass=ExtensionsDao.class)
public class Extensions {
    public static final String EXTENSION_NAME_DIVIDER = "_";
    public static final String TABLE_NAME = "gpkg_extensions";
    public static final String COLUMN_TABLE_NAME = "table_name";
    public static final String COLUMN_COLUMN_NAME = "column_name";
    public static final String COLUMN_EXTENSION_NAME = "extension_name";
    public static final String COLUMN_DEFINITION = "definition";
    public static final String COLUMN_SCOPE = "scope";
    @DatabaseField(columnName="table_name", uniqueCombo=true)
    private String tableName;
    @DatabaseField(columnName="column_name", uniqueCombo=true)
    private String columnName;
    @DatabaseField(columnName="extension_name", canBeNull=false, uniqueCombo=true)
    private String extensionName;
    @DatabaseField(columnName="definition", canBeNull=false)
    private String definition;
    @DatabaseField(columnName="scope", canBeNull=false)
    private String scope;

    public Extensions() {
    }

    public Extensions(Extensions extensions) {
        this.tableName = extensions.tableName;
        this.columnName = extensions.columnName;
        this.extensionName = extensions.extensionName;
        this.definition = extensions.definition;
        this.scope = extensions.scope;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        if (tableName == null) {
            this.columnName = null;
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public void setExtensionName(String extensionName) {
        this.extensionName = extensionName;
    }

    public void setExtensionName(String author, String extensionName) {
        this.setExtensionName(Extensions.buildExtensionName(author, extensionName));
    }

    public String getAuthor() {
        return Extensions.getAuthor(this.extensionName);
    }

    public String getExtensionNameNoAuthor() {
        return Extensions.getExtensionNameNoAuthor(this.extensionName);
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public ExtensionScopeType getScope() {
        return ExtensionScopeType.fromValue(this.scope);
    }

    public void setScope(ExtensionScopeType scope) {
        this.scope = scope.getValue();
    }

    public static String buildExtensionName(String author, String extensionName) {
        return author + EXTENSION_NAME_DIVIDER + extensionName;
    }

    public static String getAuthor(String extensionName) {
        String author = null;
        if (extensionName != null) {
            author = extensionName.substring(0, extensionName.indexOf(EXTENSION_NAME_DIVIDER));
        }
        return author;
    }

    public static String getExtensionNameNoAuthor(String extensionName) {
        String value = null;
        if (extensionName != null) {
            value = extensionName.substring(extensionName.indexOf(EXTENSION_NAME_DIVIDER) + 1, extensionName.length());
        }
        return value;
    }
}

