/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.style;

public class PixelBounds {
    private double left;
    private double up;
    private double right;
    private double down;

    public PixelBounds() {
    }

    public PixelBounds(double length) {
        this(length, length);
    }

    public PixelBounds(double width, double height) {
        this(width, height, width, height);
    }

    public PixelBounds(double left, double up, double right, double down) {
        this.left = left;
        this.up = up;
        this.right = right;
        this.down = down;
    }

    public double getLeft() {
        return this.left;
    }

    public void setLeft(double left) {
        this.left = left;
    }

    public void expandLeft(double left) {
        this.left = Math.max(this.left, left);
    }

    public double getUp() {
        return this.up;
    }

    public void setUp(double up) {
        this.up = up;
    }

    public void expandUp(double up) {
        this.up = Math.max(this.up, up);
    }

    public double getRight() {
        return this.right;
    }

    public void setRight(double right) {
        this.right = right;
    }

    public void expandRight(double right) {
        this.right = Math.max(this.right, right);
    }

    public double getDown() {
        return this.down;
    }

    public void setDown(double down) {
        this.down = down;
    }

    public void expandDown(double down) {
        this.down = Math.max(this.down, down);
    }

    public void expandWidth(double width) {
        this.expandLeft(width);
        this.expandRight(width);
    }

    public void expandHeight(double height) {
        this.expandUp(height);
        this.expandDown(height);
    }

    public void expandLength(double length) {
        this.expandWidth(length);
        this.expandHeight(length);
    }

    public double getWidth() {
        return this.left + this.right;
    }

    public double getHeight() {
        return this.up + this.down;
    }

    public double getArea() {
        return this.getWidth() * this.getHeight();
    }
}

