/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.postgres.copy;

import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import java.io.DataOutputStream;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.WKBWriter;

public class EnvelopeValueHandler
extends BaseValueHandler<Envelope> {
    private static final GeometryFactory geometryFactory = new GeometryFactory();

    private static byte[] asWKB(Envelope value) {
        Geometry geometry = geometryFactory.toGeometry(value);
        return new WKBWriter(2, 1, true).write(geometry);
    }

    protected void internalHandle(DataOutputStream buffer, Envelope value) throws Exception {
        byte[] wkb = EnvelopeValueHandler.asWKB(value);
        buffer.writeInt(wkb.length);
        buffer.write(wkb, 0, wkb.length);
    }

    public int getLength(Envelope value) {
        return EnvelopeValueHandler.asWKB(value).length + 4;
    }
}

