/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rewrite;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.Required;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="Rewrite")
public final class RewriteAppender
extends AbstractAppender {
    private final Configuration config;
    private final ConcurrentMap<String, AppenderControl> appenders = new ConcurrentHashMap<String, AppenderControl>();
    private final RewritePolicy rewritePolicy;
    private final AppenderRef[] appenderRefs;

    private RewriteAppender(String name, Filter filter, boolean ignoreExceptions, AppenderRef[] appenderRefs, RewritePolicy rewritePolicy, Configuration config, Property[] properties) {
        super(name, filter, null, ignoreExceptions, properties);
        this.config = config;
        this.rewritePolicy = rewritePolicy;
        this.appenderRefs = appenderRefs;
    }

    @Override
    public void start() {
        for (AppenderRef ref : this.appenderRefs) {
            String name = ref.getRef();
            Object appender = this.config.getAppender(name);
            if (appender != null) {
                Filter filter = appender instanceof AbstractAppender ? ((AbstractAppender)appender).getFilter() : null;
                this.appenders.put(name, new AppenderControl((Appender)appender, ref.getLevel(), filter));
                continue;
            }
            LOGGER.error("Appender " + ref + " cannot be located. Reference ignored");
        }
        super.start();
    }

    @Override
    public void append(LogEvent event) {
        if (this.rewritePolicy != null) {
            event = this.rewritePolicy.rewrite(event);
        }
        for (AppenderControl control : this.appenders.values()) {
            control.callAppender(event);
        }
    }

    @PluginFactory
    public static RewriteAppender createAppender(@PluginAttribute @Required(message="No name provided for RewriteAppender") String name, @PluginAttribute(defaultBoolean=true) @PluginAttribute(defaultBoolean=true) boolean ignoreExceptions, @PluginElement @Required(message="No appender references defined for RewriteAppender") AppenderRef[] appenderRefs, @PluginConfiguration Configuration config, @PluginElement RewritePolicy rewritePolicy, @PluginElement Filter filter) {
        return new RewriteAppender(name, filter, ignoreExceptions, appenderRefs, rewritePolicy, config, Property.EMPTY_ARRAY);
    }

    @Override
    public boolean requiresLocation() {
        for (AppenderControl control : this.appenders.values()) {
            Appender appender = control.getAppender();
            if (!appender.requiresLocation()) continue;
            return true;
        }
        return false;
    }
}

