/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Namespace(value="Converter")
@Plugin(value="notEmpty")
@ConverterKeys(value={"notEmpty", "varsNotEmpty", "variablesNotEmpty"})
@PerformanceSensitive(value={"allocation"})
public final class VariablesNotEmptyReplacementConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;

    private VariablesNotEmptyReplacementConverter(List<PatternFormatter> formatters) {
        super("notEmpty", "notEmpty");
        this.formatters = formatters;
    }

    public static VariablesNotEmptyReplacementConverter newInstance(Configuration config, String[] options) {
        if (options.length != 1) {
            LOGGER.error("Incorrect number of options on varsNotEmpty. Expected 1 received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on varsNotEmpty");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser(config);
        List<PatternFormatter> formatters = parser.parse(options[0]);
        return new VariablesNotEmptyReplacementConverter(formatters);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        int start = toAppendTo.length();
        boolean allVarsEmpty = true;
        boolean hasVars = false;
        for (int i = 0; i < this.formatters.size(); ++i) {
            PatternFormatter formatter = this.formatters.get(i);
            int formatterStart = toAppendTo.length();
            formatter.format(event, toAppendTo);
            LogEventPatternConverter converter = formatter.getConverter();
            if (!converter.isVariable()) continue;
            hasVars = true;
            allVarsEmpty = allVarsEmpty && VariablesNotEmptyReplacementConverter.sequenceRegionMatches(toAppendTo, formatterStart, converter.emptyVariableOutput());
        }
        if (!hasVars || allVarsEmpty) {
            toAppendTo.setLength(start);
        }
    }

    private static boolean sequenceRegionMatches(CharSequence sequence1, int sequence1Offset, CharSequence sequence2) {
        boolean lengthMatches;
        boolean bl = lengthMatches = sequence1.length() - sequence1Offset == sequence2.length();
        if (!lengthMatches) {
            return false;
        }
        for (int i2 = 0; i2 < sequence2.length(); ++i2) {
            int i1;
            char c1;
            char c2 = sequence2.charAt(i2);
            if (c2 == (c1 = sequence1.charAt(i1 = i2 + sequence1Offset))) continue;
            return false;
        }
        return true;
    }
}

