/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import org.apache.sis.geometry.Envelopes;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.builder.LinearTransformBuilder;
import org.apache.sis.referencing.operation.builder.ResidualGrid;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class Linearizer {
    private Linearizer() {
    }

    /*
     * Unable to fully structure code
     */
    static MathTransform approximate(MathTransform gridToCRS, Envelope domain) throws TransformException, FactoryException {
        if (domain.getDimension() != 2) {
            return Linearizer.compute(gridToCRS, domain, null);
        }
        result = null;
        it = MathTransforms.getSteps(gridToCRS).iterator();
        while (it.hasNext()) {
            block7: {
                step = it.next();
                if (step instanceof LinearTransform) {
                    result = result != null ? MathTransforms.concatenate(result, step) : step;
                    continue;
                }
                if (!(step instanceof InterpolatedTransform)) break block7;
                grid = ((InterpolatedTransform)step).getShiftGrid();
                sourceToGrid = grid.getCoordinateToGrid();
                if (result != null) {
                    sourceToGrid = MathTransforms.concatenate(result, sourceToGrid);
                }
                gd = Envelopes.transform(sourceToGrid, domain);
                if (!(grid instanceof ResidualGrid)) ** GOTO lbl20
                for (i = 0; i < 2; ++i) {
                    if (!(gd.getMinimum(i) >= 0.5) && !(gd.getMaximum(i) <= (double)grid.getGridSize(i) - 1.5)) {
                        continue;
                    }
lbl20:
                    // 4 sources

                    while (it.hasNext()) {
                        step = MathTransforms.concatenate(step, it.next());
                    }
                    return MathTransforms.concatenate(sourceToGrid, Linearizer.compute(step, gd, grid));
                }
                continue;
            }
            return Linearizer.compute(gridToCRS, domain, null);
        }
        return result;
    }

    private static MathTransform compute(MathTransform gridToCRS, Envelope domain, DatumShiftGrid<?, ?> grid) throws TransformException, FactoryException {
        int[] size = new int[domain.getDimension()];
        double[] shift = new double[size.length];
        for (int i = 0; i < size.length; ++i) {
            double span;
            double lower = Math.rint(domain.getMinimum(i));
            double upper = Math.rint(domain.getMaximum(i));
            if (grid != null) {
                double h = grid.getGridSize(i);
                if (upper > h) {
                    upper = h;
                }
                if (lower < 0.0) {
                    lower = 0.0;
                }
            }
            if (!((span = upper - lower) <= 2.147483647E9)) {
                throw new ArithmeticException(Errors.format((short)10, (Object)32));
            }
            shift[i] = lower;
            size[i] = (int)span;
        }
        LinearTransformBuilder builder = new LinearTransformBuilder(size);
        LinearTransform translate = MathTransforms.translation(shift);
        builder.setControlPoints(MathTransforms.concatenate(translate, gridToCRS));
        return MathTransforms.concatenate(translate.inverse(), builder.create(null));
    }
}

