/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Arrays;
import java.util.Map;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.TensorParameters;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.EPSGName;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;

@XmlTransient
public final class Affine
extends AbstractProvider {
    private static final long serialVersionUID = 9061544057836352125L;
    public static final String NAME = "Affine parametric transformation";
    public static final int EPSG_DIMENSION = 2;
    private static final int MAX_CACHED_DIMENSION = 6;
    private static final Affine[] CACHED = new Affine[36];
    private static final Map<String, ?> IDENTIFICATION_EPSG;
    private static final Map<String, ?> IDENTIFICATION_OGC;
    private static final Affine EPSG_METHOD;
    private final int sourceDimensions;
    private final int targetDimensions;

    public Affine() {
        super(IDENTIFICATION_EPSG, new Descriptor(IDENTIFICATION_EPSG, Arrays.copyOfRange(TensorParameters.ALPHANUM.getAllDescriptors(2, 3), 2, 8)));
        this.sourceDimensions = 2;
        this.targetDimensions = 2;
    }

    private Affine(int sourceDimensions, int targetDimensions) {
        super(IDENTIFICATION_OGC, new Descriptor(IDENTIFICATION_OGC, TensorParameters.WKT1.getAllDescriptors(targetDimensions + 1, sourceDimensions + 1)));
        this.sourceDimensions = sourceDimensions;
        this.targetDimensions = targetDimensions;
    }

    @Override
    @Deprecated
    public Integer getSourceDimensions() {
        return this.sourceDimensions;
    }

    @Override
    @Deprecated
    public Integer getTargetDimensions() {
        return this.targetDimensions;
    }

    @Override
    public AbstractProvider variantFor(MathTransform transform) {
        boolean isAffine = transform instanceof LinearTransform && ((LinearTransform)transform).isAffine();
        return Affine.provider(transform.getSourceDimensions(), transform.getTargetDimensions(), isAffine);
    }

    @Override
    public AbstractProvider redimension(int sourceDimensions, int targetDimensions) {
        return Affine.provider(sourceDimensions, targetDimensions, false);
    }

    @Override
    public AbstractProvider inverse() {
        return this;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws ParameterNotFoundException {
        return MathTransforms.linear(TensorParameters.WKT1.toMatrix(values));
    }

    private static int cacheIndex(int sourceDimensions, int targetDimensions) {
        if (--sourceDimensions >= 0 && sourceDimensions < 6 && --targetDimensions >= 0 && targetDimensions < 6) {
            return sourceDimensions * 6 + targetDimensions;
        }
        return -1;
    }

    public static Affine provider() {
        return EPSG_METHOD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Affine provider(int sourceDimensions, int targetDimensions, boolean isAffine) {
        Affine method;
        Affine[] affineArray;
        if (isAffine && sourceDimensions == 2 && targetDimensions == 2) {
            return EPSG_METHOD;
        }
        int index = Affine.cacheIndex(sourceDimensions, targetDimensions);
        if (index >= 0) {
            affineArray = CACHED;
            // MONITORENTER : CACHED
            method = CACHED[index];
            // MONITOREXIT : affineArray
            if (method != null) {
                return method;
            }
        }
        method = new Affine(sourceDimensions, targetDimensions);
        if (index < 0) return method;
        affineArray = CACHED;
        // MONITORENTER : CACHED
        Affine other = CACHED[index];
        if (other != null) {
            // MONITOREXIT : affineArray
            return other;
        }
        Affine.CACHED[index] = method;
        // MONITOREXIT : affineArray
        return method;
    }

    public static ParameterValueGroup identity(int dimension) {
        ParameterValueGroup values = TensorParameters.WKT1.createValueGroup(Map.of("name", "Affine"));
        values.parameter("num_col").setValue(++dimension);
        values.parameter("num_row").setValue(dimension);
        return values;
    }

    public static ParameterValueGroup parameters(Matrix matrix) {
        Map<String, ?> properties;
        TensorParameters<Double> parameters;
        int sourceDimensions = matrix.getNumCol() - 1;
        int targetDimensions = matrix.getNumRow() - 1;
        if (sourceDimensions == 2 && targetDimensions == 2 && Matrices.isAffine(matrix)) {
            parameters = TensorParameters.ALPHANUM;
            properties = IDENTIFICATION_EPSG;
        } else {
            parameters = TensorParameters.WKT1;
            properties = IDENTIFICATION_OGC;
        }
        return parameters.createValueGroup(properties, matrix);
    }

    static {
        NamedIdentifier nameOGC = new NamedIdentifier((Citation)Citations.OGC, "OGC", (CharSequence)"Affine", null, null);
        IDENTIFICATION_OGC = Map.of("name", nameOGC);
        IDENTIFICATION_EPSG = EPSGName.properties(9624, NAME, nameOGC);
        EPSG_METHOD = new Affine();
    }

    private static final class Descriptor
    extends DefaultParameterDescriptorGroup {
        private static final long serialVersionUID = 8320799650519834830L;

        Descriptor(Map<String, ?> properties, ParameterDescriptor<?>[] parameters) {
            super(properties, 1, 1, (GeneralParameterDescriptor[])parameters);
        }

        @Override
        public ParameterValueGroup createValue() {
            return TensorParameters.WKT1.createValueGroup(IDENTIFICATION_OGC);
        }
    }
}

