/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.io.GeoPackageProgress;

public class Progress
implements GeoPackageProgress {
    private static final Logger LOGGER = Logger.getLogger(Progress.class.getName());
    protected DecimalFormat decimalFormat = new DecimalFormat("0.00");
    protected Integer max = null;
    protected int progress = 0;
    protected boolean active = true;
    protected final String title;
    protected final String unit;
    protected int countFrequency;
    protected int timeFrequency;
    protected int localCount = 0;
    protected Date localTime = new Date();

    public Progress(String title, int countFrequency, int timeFrequency) {
        this(title, null, countFrequency, timeFrequency);
    }

    public Progress(String title, String unit, int countFrequency, int timeFrequency) {
        this.title = title;
        this.unit = unit != null ? " " + unit : "";
        this.setCountFrequency(countFrequency);
        this.setTimeFrequency(timeFrequency);
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void addProgress(int progress) {
        this.progress += progress;
        this.localCount += progress;
        if (this.localCount >= this.countFrequency || this.localTime.getTime() + (long)this.timeFrequency <= new Date().getTime() || this.max != null && this.max == this.progress) {
            this.logProgress();
            this.localCount = 0;
            this.localTime = new Date();
        }
    }

    protected void logProgress() {
        LOGGER.log(Level.INFO, this.title + " - " + this.progress + (String)(this.max != null ? " of " + this.max + this.unit + " (" + this.getPercentage(this.progress, this.max) + ")" : this.unit));
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean cleanupOnCancel() {
        return false;
    }

    public void cancel() {
        this.active = false;
    }

    public Integer getMax() {
        return this.max;
    }

    public int getCountFrequency() {
        return this.countFrequency;
    }

    public void setCountFrequency(int countFrequency) {
        this.countFrequency = countFrequency;
    }

    public int getTimeFrequency() {
        return this.timeFrequency / 1000;
    }

    public void setTimeFrequency(int timeFrequency) {
        this.timeFrequency = timeFrequency * 1000;
    }

    public int getProgress() {
        return this.progress;
    }

    protected String getPercentage(int count, int total) {
        return this.decimalFormat.format((double)count / (double)total * 100.0) + "%";
    }
}

