/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.proj;

import java.util.ArrayList;
import java.util.List;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionFactory;
import mil.nga.proj.ProjectionTransform;
import mil.nga.sf.CircularString;
import mil.nga.sf.CompoundCurve;
import mil.nga.sf.Curve;
import mil.nga.sf.CurvePolygon;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryCollection;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.MultiLineString;
import mil.nga.sf.MultiPoint;
import mil.nga.sf.MultiPolygon;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.PolyhedralSurface;
import mil.nga.sf.TIN;
import mil.nga.sf.Triangle;
import mil.nga.sf.util.SFException;
import org.locationtech.proj4j.ProjCoordinate;

public class GeometryTransform
extends ProjectionTransform {
    public static GeometryTransform create(Projection fromProjection, Projection toProjection) {
        return new GeometryTransform(fromProjection, toProjection);
    }

    public static GeometryTransform create(Projection fromProjection, long toEpsg) {
        return new GeometryTransform(fromProjection, ProjectionFactory.getProjection((long)toEpsg));
    }

    public static GeometryTransform create(Projection fromProjection, String toAuthority, long toCode) {
        return new GeometryTransform(fromProjection, ProjectionFactory.getProjection((String)toAuthority, (long)toCode));
    }

    public static GeometryTransform create(Projection fromProjection, String toAuthority, String toCode) {
        return new GeometryTransform(fromProjection, ProjectionFactory.getProjection((String)toAuthority, (String)toCode));
    }

    public static GeometryTransform create(long fromEpsg, Projection toProjection) {
        return new GeometryTransform(ProjectionFactory.getProjection((long)fromEpsg), toProjection);
    }

    public static GeometryTransform create(String fromAuthority, long fromCode, Projection toProjection) {
        return new GeometryTransform(ProjectionFactory.getProjection((String)fromAuthority, (long)fromCode), toProjection);
    }

    public static GeometryTransform create(String fromAuthority, String fromCode, Projection toProjection) {
        return new GeometryTransform(ProjectionFactory.getProjection((String)fromAuthority, (String)fromCode), toProjection);
    }

    public static GeometryTransform create(long fromEpsg, long toEpsg) {
        return new GeometryTransform(ProjectionFactory.getProjection((long)fromEpsg), ProjectionFactory.getProjection((long)toEpsg));
    }

    public static GeometryTransform create(String fromAuthority, long fromCode, String toAuthority, long toCode) {
        return new GeometryTransform(ProjectionFactory.getProjection((String)fromAuthority, (long)fromCode), ProjectionFactory.getProjection((String)toAuthority, (long)toCode));
    }

    public static GeometryTransform create(String fromAuthority, String fromCode, String toAuthority, String toCode) {
        return new GeometryTransform(ProjectionFactory.getProjection((String)fromAuthority, (String)fromCode), ProjectionFactory.getProjection((String)toAuthority, (String)toCode));
    }

    public static GeometryTransform create(ProjectionTransform transform) {
        return new GeometryTransform(transform);
    }

    public GeometryTransform(Projection fromProjection, Projection toProjection) {
        super(fromProjection, toProjection);
    }

    public GeometryTransform(ProjectionTransform transform) {
        super(transform);
    }

    public GeometryTransform getInverseTransformation() {
        return GeometryTransform.create(this.toProjection, this.fromProjection);
    }

    public GeometryEnvelope transform(GeometryEnvelope envelope) {
        double[] bounds = this.transform(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
        GeometryEnvelope projectedEnvelope = new GeometryEnvelope(bounds[0], bounds[1], bounds[2], bounds[3]);
        return projectedEnvelope;
    }

    public Geometry transform(Geometry geometry) {
        GeometryCollection<Geometry> to = null;
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case POINT: {
                to = this.transform((Point)geometry);
                break;
            }
            case LINESTRING: {
                to = this.transform((LineString)geometry);
                break;
            }
            case POLYGON: {
                to = this.transform((Polygon)geometry);
                break;
            }
            case MULTIPOINT: {
                to = this.transform((MultiPoint)geometry);
                break;
            }
            case MULTILINESTRING: {
                to = this.transform((MultiLineString)geometry);
                break;
            }
            case MULTIPOLYGON: {
                to = this.transform((MultiPolygon)geometry);
                break;
            }
            case CIRCULARSTRING: {
                to = this.transform((CircularString)geometry);
                break;
            }
            case COMPOUNDCURVE: {
                to = this.transform((CompoundCurve)geometry);
                break;
            }
            case CURVEPOLYGON: {
                to = this.transform((CurvePolygon)geometry);
                break;
            }
            case POLYHEDRALSURFACE: {
                to = this.transform((PolyhedralSurface)geometry);
                break;
            }
            case TIN: {
                to = this.transform((TIN)geometry);
                break;
            }
            case TRIANGLE: {
                to = this.transform((Triangle)geometry);
                break;
            }
            case GEOMETRYCOLLECTION: {
                GeometryCollection<Geometry> toCollection;
                to = toCollection = this.transform((GeometryCollection<Geometry>)((GeometryCollection)geometry));
                break;
            }
            default: {
                throw new SFException("Unsupported Geometry Type: " + geometryType);
            }
        }
        return to;
    }

    public Point transform(Point from) {
        ProjCoordinate fromCoord = from.hasZ() ? new ProjCoordinate(from.getX(), from.getY(), from.getZ() != null ? from.getZ() : Double.NaN) : new ProjCoordinate(from.getX(), from.getY());
        ProjCoordinate toCoord = this.transform(fromCoord);
        Point to = new Point(from.hasZ(), from.hasM(), toCoord.x, toCoord.y);
        if (from.hasZ()) {
            if (Double.isNaN(toCoord.z)) {
                to.setZ(from.getZ());
            } else {
                to.setZ(Double.valueOf(toCoord.z));
            }
        }
        if (from.hasM()) {
            to.setM(from.getM());
        }
        return to;
    }

    public List<Point> transform(List<Point> from) {
        ArrayList<Point> to = new ArrayList<Point>();
        for (Point fromPoint : from) {
            Point toPoint = this.transform(fromPoint);
            to.add(toPoint);
        }
        return to;
    }

    public LineString transform(LineString lineString) {
        CircularString to = null;
        switch (lineString.getGeometryType()) {
            case CIRCULARSTRING: {
                to = new CircularString(lineString.hasZ(), lineString.hasM());
                break;
            }
            default: {
                to = new LineString(lineString.hasZ(), lineString.hasM());
            }
        }
        for (Point point : lineString.getPoints()) {
            Point toPoint = this.transform(point);
            to.addPoint(toPoint);
        }
        return to;
    }

    public Polygon transform(Polygon polygon) {
        Triangle to = null;
        switch (polygon.getGeometryType()) {
            case TRIANGLE: {
                to = new Triangle(polygon.hasZ(), polygon.hasM());
                break;
            }
            default: {
                to = new Polygon(polygon.hasZ(), polygon.hasM());
            }
        }
        for (LineString ring : polygon.getRings()) {
            LineString toRing = this.transform(ring);
            to.addRing((Curve)toRing);
        }
        return to;
    }

    public MultiPoint transform(MultiPoint multiPoint) {
        MultiPoint to = new MultiPoint(multiPoint.hasZ(), multiPoint.hasM());
        for (Point point : multiPoint.getPoints()) {
            Point toPoint = this.transform(point);
            to.addPoint(toPoint);
        }
        return to;
    }

    public MultiLineString transform(MultiLineString multiLineString) {
        MultiLineString to = new MultiLineString(multiLineString.hasZ(), multiLineString.hasM());
        for (LineString lineString : multiLineString.getLineStrings()) {
            LineString toLineString = this.transform(lineString);
            to.addLineString(toLineString);
        }
        return to;
    }

    public MultiPolygon transform(MultiPolygon multiPolygon) {
        MultiPolygon to = new MultiPolygon(multiPolygon.hasZ(), multiPolygon.hasM());
        for (Polygon polygon : multiPolygon.getPolygons()) {
            Polygon toPolygon = this.transform(polygon);
            to.addPolygon(toPolygon);
        }
        return to;
    }

    public CircularString transform(CircularString circularString) {
        return (CircularString)this.transform((LineString)circularString);
    }

    public CompoundCurve transform(CompoundCurve compoundCurve) {
        CompoundCurve to = new CompoundCurve(compoundCurve.hasZ(), compoundCurve.hasM());
        for (LineString lineString : compoundCurve.getLineStrings()) {
            LineString toLineString = this.transform(lineString);
            to.addLineString(toLineString);
        }
        return to;
    }

    public <T extends Curve> CurvePolygon<T> transform(CurvePolygon<T> curvePolygon) {
        CurvePolygon to = new CurvePolygon(curvePolygon.hasZ(), curvePolygon.hasM());
        for (Curve ring : curvePolygon.getRings()) {
            CompoundCurve toRing = null;
            switch (ring.getGeometryType()) {
                case COMPOUNDCURVE: {
                    toRing = this.transform((CompoundCurve)ring);
                    break;
                }
                default: {
                    toRing = this.transform((LineString)ring);
                }
            }
            CompoundCurve typedToRing = toRing;
            to.addRing((Curve)typedToRing);
        }
        return to;
    }

    public PolyhedralSurface transform(PolyhedralSurface polyhedralSurface) {
        TIN to = null;
        switch (polyhedralSurface.getGeometryType()) {
            case TIN: {
                to = new TIN(polyhedralSurface.hasZ(), polyhedralSurface.hasM());
                break;
            }
            default: {
                to = new PolyhedralSurface(polyhedralSurface.hasZ(), polyhedralSurface.hasM());
            }
        }
        for (Polygon polygon : polyhedralSurface.getPolygons()) {
            Polygon toPolygon = this.transform(polygon);
            to.addPolygon(toPolygon);
        }
        return to;
    }

    public TIN transform(TIN tin) {
        return (TIN)this.transform((PolyhedralSurface)tin);
    }

    public Triangle transform(Triangle triangle) {
        return (Triangle)this.transform((Polygon)triangle);
    }

    public GeometryCollection<Geometry> transform(GeometryCollection<Geometry> geometryCollection) {
        GeometryCollection to = new GeometryCollection(geometryCollection.hasZ(), geometryCollection.hasM());
        for (Geometry geometry : geometryCollection.getGeometries()) {
            Geometry toGeometry = this.transform(geometry);
            to.addGeometry(toGeometry);
        }
        return to;
    }
}

