/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.healthcheck;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.DynamicEndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.DefaultHealthCheckerContext;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckContextGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckStrategy;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroupBuilder;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroupMetrics;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckerContext;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.common.util.AsyncCloseable;
import com.linecorp.armeria.internal.client.endpoint.EndpointAttributeKeys;
import com.linecorp.armeria.internal.common.util.CollectionUtil;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.shaded.futures.CompletableFutures;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HealthCheckedEndpointGroup
extends DynamicEndpointGroup {
    private static final Logger logger = LoggerFactory.getLogger(HealthCheckedEndpointGroup.class);
    final EndpointGroup delegate;
    private final long initialSelectionTimeoutMillis;
    private final long selectionTimeoutMillis;
    private final SessionProtocol protocol;
    private final int port;
    private final Backoff retryBackoff;
    private final ClientOptions clientOptions;
    private final Function<? super HealthCheckerContext, ? extends AsyncCloseable> checkerFactory;
    final HealthCheckStrategy healthCheckStrategy;
    private final Predicate<Endpoint> healthCheckedEndpointPredicate;
    private final ReentrantLock lock = new ReentrantShortLock();
    @GuardedBy(value="lock")
    private final Deque<HealthCheckContextGroup> contextGroupChain = new ArrayDeque<HealthCheckContextGroup>(4);
    final Map<Endpoint, Endpoint> cachedEndpoints = new ConcurrentHashMap<Endpoint, Endpoint>();
    private volatile boolean initialized;

    public static HealthCheckedEndpointGroup of(EndpointGroup delegate, String path) {
        return HealthCheckedEndpointGroup.builder(delegate, path).build();
    }

    public static HealthCheckedEndpointGroupBuilder builder(EndpointGroup delegate, String path) {
        return new HealthCheckedEndpointGroupBuilder(delegate, path);
    }

    HealthCheckedEndpointGroup(EndpointGroup delegate, boolean allowEmptyEndpoints, long initialSelectionTimeoutMillis, long selectionTimeoutMillis, SessionProtocol protocol, int port, Backoff retryBackoff, ClientOptions clientOptions, Function<? super HealthCheckerContext, ? extends AsyncCloseable> checkerFactory, HealthCheckStrategy healthCheckStrategy, Predicate<Endpoint> healthCheckedEndpointPredicate) {
        super(Objects.requireNonNull(delegate, "delegate").selectionStrategy(), allowEmptyEndpoints);
        this.delegate = delegate;
        this.initialSelectionTimeoutMillis = initialSelectionTimeoutMillis;
        this.selectionTimeoutMillis = selectionTimeoutMillis;
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        this.port = port;
        this.retryBackoff = Objects.requireNonNull(retryBackoff, "retryBackoff");
        this.clientOptions = Objects.requireNonNull(clientOptions, "clientOptions");
        this.checkerFactory = Objects.requireNonNull(checkerFactory, "checkerFactory");
        this.healthCheckStrategy = Objects.requireNonNull(healthCheckStrategy, "healthCheckStrategy");
        this.healthCheckedEndpointPredicate = Objects.requireNonNull(healthCheckedEndpointPredicate, "healthCheckedEndpointPredicate");
        clientOptions.factory().whenClosed().thenRun(this::closeAsync);
        delegate.addListener(this::setCandidates, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCandidates(List<Endpoint> endpoints) {
        List<Endpoint> candidates = this.healthCheckStrategy.select(endpoints);
        HashMap<Endpoint, DefaultHealthCheckerContext> contexts = new HashMap<Endpoint, DefaultHealthCheckerContext>(candidates.size());
        this.lock.lock();
        try {
            for (Endpoint endpoint : candidates) {
                if (contexts.containsKey(endpoint)) continue;
                DefaultHealthCheckerContext context = this.findContext(endpoint);
                if (context != null) {
                    contexts.put(endpoint, context.retain());
                    continue;
                }
                contexts.computeIfAbsent(endpoint, this::newCheckerContext);
            }
            HealthCheckContextGroup contextGroup = new HealthCheckContextGroup(contexts, candidates, this.checkerFactory);
            this.contextGroupChain.add(contextGroup);
            contextGroup.initialize();
            contextGroup.whenInitialized().handle((unused, cause) -> {
                if (cause != null && !this.initialized && logger.isWarnEnabled()) {
                    logger.warn("The first health check failed for all endpoints. numCandidates: {} candidates: {}", new Object[]{candidates.size(), CollectionUtil.truncate(candidates, 10), cause});
                }
                this.initialized = true;
                this.destroyOldContexts(contextGroup);
                this.setEndpoints(this.allHealthyEndpoints());
                return null;
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    Queue<HealthCheckContextGroup> contextGroupChain() {
        return this.contextGroupChain;
    }

    List<Endpoint> allHealthyEndpoints() {
        this.lock.lock();
        try {
            List<Endpoint> list = this.allEndpoints().stream().filter(this.healthCheckedEndpointPredicate).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Endpoint> allEndpoints() {
        this.lock.lock();
        try {
            HealthCheckContextGroup newGroup = this.contextGroupChain.peekLast();
            if (newGroup == null) {
                ImmutableList<Endpoint> immutableList = ImmutableList.of();
                return immutableList;
            }
            ArrayList<Endpoint> allEndpoints = new ArrayList<Endpoint>(newGroup.candidates());
            for (HealthCheckContextGroup oldGroup : this.contextGroupChain) {
                if (oldGroup == newGroup) break;
                for (Endpoint candidate : oldGroup.candidates()) {
                    if (allEndpoints.contains(candidate)) continue;
                    allEndpoints.add(candidate);
                }
            }
            ArrayList<Endpoint> arrayList = allEndpoints;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DefaultHealthCheckerContext findContext(Endpoint endpoint) {
        this.lock.lock();
        try {
            for (HealthCheckContextGroup contextGroup : this.contextGroupChain) {
                DefaultHealthCheckerContext context = contextGroup.contexts().get(endpoint);
                if (context == null) continue;
                DefaultHealthCheckerContext defaultHealthCheckerContext = context;
                return defaultHealthCheckerContext;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    private DefaultHealthCheckerContext newCheckerContext(Endpoint endpoint) {
        return new DefaultHealthCheckerContext(endpoint, this.port, this.protocol, this.clientOptions, this.retryBackoff, this::updateHealth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyOldContexts(HealthCheckContextGroup contextGroup) {
        this.lock.lock();
        try {
            if (!this.contextGroupChain.contains(contextGroup)) {
                return;
            }
            Iterator<HealthCheckContextGroup> it = this.contextGroupChain.iterator();
            while (it.hasNext()) {
                HealthCheckContextGroup maybeOldGroup = it.next();
                if (maybeOldGroup == contextGroup) {
                    break;
                }
                for (DefaultHealthCheckerContext context : maybeOldGroup.contexts().values()) {
                    context.release();
                }
                it.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateHealth(Endpoint endpoint, boolean health) {
        Endpoint cached;
        boolean updated = health && this.findContext(endpoint) != null ? (cached = this.cachedEndpoints.put(endpoint, endpoint)) == null || !EndpointAttributeKeys.equalHealthCheckAttributes(cached, endpoint) : this.cachedEndpoints.remove(endpoint, endpoint);
        if (updated && this.initialized) {
            this.setEndpoints(this.allHealthyEndpoints());
        }
    }

    @Override
    public long selectionTimeoutMillis() {
        return this.initialized ? this.selectionTimeoutMillis : this.initialSelectionTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCloseAsync(CompletableFuture<?> future) {
        CompletableFuture stopFutures;
        this.lock.lock();
        try {
            ImmutableList.Builder completionFutures = ImmutableList.builder();
            for (HealthCheckContextGroup group : this.contextGroupChain) {
                for (DefaultHealthCheckerContext context : group.contexts().values()) {
                    try {
                        CompletableFuture<?> closeFuture = context.release();
                        if (closeFuture == null) continue;
                        completionFutures.add(closeFuture.exceptionally(cause -> {
                            logger.warn("Failed to stop a health checker for: {}", (Object)context.endpoint(), cause);
                            return null;
                        }));
                    }
                    catch (Exception ex) {
                        logger.warn("Unexpected exception while closing a health checker for: {}", (Object)context.endpoint(), (Object)ex);
                    }
                }
            }
            stopFutures = CompletableFutures.allAsList(completionFutures.build());
        }
        finally {
            this.lock.unlock();
        }
        ((CompletableFuture)stopFutures.handle((unused1, unused2) -> {
            this.lock.lock();
            try {
                this.contextGroupChain.clear();
            }
            finally {
                this.lock.unlock();
            }
            return this.delegate.closeAsync();
        })).handle((unused1, unused2) -> future.complete(null));
    }

    public MeterBinder newMeterBinder(String groupName) {
        return this.newMeterBinder(new MeterIdPrefix("armeria.client.endpoint.group", "name", groupName));
    }

    public MeterBinder newMeterBinder(MeterIdPrefix idPrefix) {
        return new HealthCheckedEndpointGroupMetrics(this, idPrefix);
    }

    @Override
    public String toString() {
        List<Endpoint> endpoints = this.endpoints();
        List<Endpoint> delegateEndpoints = this.delegate.endpoints();
        return MoreObjects.toStringHelper(this).add("endpoints", CollectionUtil.truncate(endpoints, 10)).add("numEndpoints", endpoints.size()).add("candidates", CollectionUtil.truncate(delegateEndpoints, 10)).add("numCandidates", delegateEndpoints.size()).add("selectionStrategy", this.selectionStrategy().getClass()).add("initialized", this.whenReady().isDone()).add("initialSelectionTimeoutMillis", this.initialSelectionTimeoutMillis).add("selectionTimeoutMillis", this.selectionTimeoutMillis).add("contextGroupChain", this.contextGroupChain).toString();
    }
}

