/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.google.errorprone.annotations.MustBeClosed;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.common.ContextAwareBlockingTaskExecutor;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.common.util.TimeoutMode;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ProxiedAddresses;
import com.linecorp.armeria.server.RequestCancellationException;
import com.linecorp.armeria.server.RequestTimeoutException;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContextBuilder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public interface ServiceRequestContext
extends RequestContext {
    public static ServiceRequestContext current() {
        Object ctx = RequestContext.current();
        ServiceRequestContext root = ctx.root();
        if (root != null) {
            return root;
        }
        throw new IllegalStateException("The current context is not a server-side context and does not have a root which means that the context is not invoked by a server request. ctx: " + ctx);
    }

    @Nullable
    public static ServiceRequestContext currentOrNull() {
        Object ctx = RequestContext.currentOrNull();
        if (ctx == null) {
            return null;
        }
        return ctx.root();
    }

    @Nullable
    public static <T> T mapCurrent(Function<? super ServiceRequestContext, T> mapper, @Nullable @Nullable Supplier<@Nullable T> defaultValueSupplier) {
        ServiceRequestContext ctx = ServiceRequestContext.currentOrNull();
        if (ctx != null) {
            return mapper.apply(ctx);
        }
        ClientRequestContext clientRequestContext = ClientRequestContext.currentOrNull();
        if (clientRequestContext != null) {
            throw new IllegalStateException("The current context is not a server-side context and does not have a root which means that the context is not invoked by a server request. ctx: " + clientRequestContext);
        }
        if (defaultValueSupplier != null) {
            return defaultValueSupplier.get();
        }
        return null;
    }

    public static ServiceRequestContext of(HttpRequest request) {
        return ServiceRequestContext.builder(request).build();
    }

    public static ServiceRequestContextBuilder builder(HttpRequest request) {
        return new ServiceRequestContextBuilder(request);
    }

    @Override
    @Nonnull
    default public ServiceRequestContext root() {
        return this;
    }

    @Override
    @Nonnull
    public HttpRequest request();

    @Override
    @Nullable
    public RpcRequest rpcRequest();

    @Override
    @Nonnull
    public InetSocketAddress remoteAddress();

    @Override
    @Nonnull
    public InetSocketAddress localAddress();

    public InetAddress clientAddress();

    @Override
    @MustBeClosed
    default public SafeCloseable push() {
        Object oldCtx = RequestContextUtil.getAndSet(this);
        if (oldCtx == null) {
            return RequestContextUtil.invokeHookAndPop(this, null);
        }
        if (oldCtx.unwrapAll() == this.unwrapAll()) {
            SafeCloseable closeable = RequestContextUtil.invokeHook(this);
            return MoreObjects.firstNonNull(closeable, RequestContextUtil.noopSafeCloseable());
        }
        if (RequestContextUtil.equalsIgnoreWrapper(oldCtx.root(), this)) {
            return RequestContextUtil.invokeHookAndPop(this, oldCtx);
        }
        RequestContextUtil.pop(this, oldCtx);
        throw RequestContextUtil.newIllegalContextPushingException(this, oldCtx);
    }

    public ServiceConfig config();

    @Nullable
    @UnstableApi
    public <T extends HttpService> T findService(Class<? extends T> var1);

    public RoutingContext routingContext();

    public Map<String, String> pathParams();

    @Nullable
    default public String pathParam(String name) {
        return this.pathParams().get(name);
    }

    public QueryParams queryParams();

    default public List<String> queryParams(String name) {
        return this.queryParams().getAll(name);
    }

    @Nullable
    default public String queryParam(String name) {
        return this.queryParams().get(name);
    }

    public ContextAwareBlockingTaskExecutor blockingTaskExecutor();

    public String mappedPath();

    public String decodedMappedPath();

    @Override
    @UnstableApi
    public URI uri();

    @Nullable
    public MediaType negotiatedResponseMediaType();

    public long requestTimeoutMillis();

    public void clearRequestTimeout();

    default public void setRequestTimeoutMillis(long requestTimeoutMillis) {
        this.setRequestTimeoutMillis(TimeoutMode.SET_FROM_NOW, requestTimeoutMillis);
    }

    public void setRequestTimeoutMillis(TimeoutMode var1, long var2);

    default public void setRequestTimeout(Duration requestTimeout) {
        this.setRequestTimeout(TimeoutMode.SET_FROM_NOW, requestTimeout);
    }

    public void setRequestTimeout(TimeoutMode var1, Duration var2);

    public CompletableFuture<Throwable> whenRequestCancelling();

    public CompletableFuture<Throwable> whenRequestCancelled();

    @Deprecated
    public CompletableFuture<Void> whenRequestTimingOut();

    @Deprecated
    public CompletableFuture<Void> whenRequestTimedOut();

    @Override
    default public void cancel() {
        this.cancel(RequestCancellationException.get());
    }

    @Override
    default public void timeoutNow() {
        this.cancel(RequestTimeoutException.get());
    }

    public long maxRequestLength();

    public void setMaxRequestLength(long var1);

    public HttpHeaders additionalResponseHeaders();

    public void setAdditionalResponseHeader(CharSequence var1, Object var2);

    public void addAdditionalResponseHeader(CharSequence var1, Object var2);

    public void mutateAdditionalResponseHeaders(Consumer<HttpHeadersBuilder> var1);

    public HttpHeaders additionalResponseTrailers();

    public void setAdditionalResponseTrailer(CharSequence var1, Object var2);

    public void addAdditionalResponseTrailer(CharSequence var1, Object var2);

    public void mutateAdditionalResponseTrailers(Consumer<HttpHeadersBuilder> var1);

    public ProxiedAddresses proxiedAddresses();

    @Deprecated
    public boolean shouldReportUnhandledExceptions();

    @Deprecated
    public void setShouldReportUnhandledExceptions(boolean var1);

    public boolean shouldReportUnloggedExceptions();

    public void setShouldReportUnloggedExceptions(boolean var1);

    @UnstableApi
    public CompletableFuture<Void> initiateConnectionShutdown(long var1);

    @UnstableApi
    default public CompletableFuture<Void> initiateConnectionShutdown(Duration drainDuration) {
        Objects.requireNonNull(drainDuration, "drainDuration");
        return this.initiateConnectionShutdown(TimeUnit.NANOSECONDS.toMicros(drainDuration.toNanos()));
    }

    @Override
    @UnstableApi
    public CompletableFuture<Void> initiateConnectionShutdown();

    @Override
    public ExchangeType exchangeType();

    @Override
    default public ServiceRequestContext unwrap() {
        return (ServiceRequestContext)RequestContext.super.unwrap();
    }

    @Override
    default public ServiceRequestContext unwrapAll() {
        return (ServiceRequestContext)RequestContext.super.unwrapAll();
    }
}

