/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.management;

import com.linecorp.armeria.common.ContentDisposition;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.common.util.ThreadFactories;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.file.HttpFile;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum HeapDumpService implements HttpService
{
    INSTANCE;

    private static final Logger logger;
    private static final Executor heapDumpExecutor;
    @Nullable
    private HeapDumper heapDumper;
    @Nullable
    private Throwable unavailabilityCause;

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        if (this.unavailabilityCause != null) {
            return HttpResponse.ofFailure(this.unavailabilityCause);
        }
        CompletableFuture responseFuture = new CompletableFuture();
        heapDumpExecutor.execute(() -> {
            if (ctx.isCancelled()) {
                return;
            }
            if (this.heapDumper == null) {
                try {
                    this.heapDumper = new HeapDumper();
                }
                catch (Throwable ex) {
                    this.unavailabilityCause = ex;
                    responseFuture.complete(HttpResponse.ofFailure(ex));
                    return;
                }
            }
            File tempFile = null;
            try {
                QueryParams queryParams = QueryParams.fromQueryString(ctx.query());
                boolean live = queryParams.contains("live", "true");
                String date = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm").format(LocalDateTime.now());
                String fileName = "heapdump_pid" + SystemInfo.pid() + '_' + date + (live ? "_live" : "");
                tempFile = HeapDumpService.createTempFile(fileName);
                this.heapDumper.dumpHeap(tempFile, live);
                ContentDisposition disposition = ContentDisposition.builder("attachment").filename(fileName + ".hprof").build();
                HttpFile httpFile = HttpFile.builder(tempFile).addHeader((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, disposition).build();
                File heapDumpFile = tempFile;
                HttpResponse httpResponse = httpFile.asService().serve(ctx, req);
                responseFuture.complete(httpResponse);
                httpResponse.whenComplete().handleAsync((unused1, unused2) -> {
                    HeapDumpService.deleteTempFile(heapDumpFile);
                    return null;
                }, heapDumpExecutor);
            }
            catch (Throwable cause) {
                logger.warn("Unexpected exception while creating a heap dump", cause);
                if (tempFile != null) {
                    HeapDumpService.deleteTempFile(tempFile);
                }
                responseFuture.complete(HttpResponse.ofFailure(cause));
            }
        });
        return HttpResponse.of(responseFuture);
    }

    @Override
    public ExchangeType exchangeType(RoutingContext routingContext) {
        if (routingContext.headers().method() == HttpMethod.GET) {
            return ExchangeType.RESPONSE_STREAMING;
        }
        return ExchangeType.BIDI_STREAMING;
    }

    private static File createTempFile(String fileName) throws IOException {
        File file = File.createTempFile(fileName, ".hprof");
        file.delete();
        return file;
    }

    private static void deleteTempFile(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException ex) {
            logger.warn("Failed to delete temporary heap dump file '" + file + '\'', (Throwable)ex);
        }
    }

    static {
        logger = LoggerFactory.getLogger(HeapDumpService.class);
        heapDumpExecutor = Executors.newSingleThreadExecutor(ThreadFactories.newThreadFactory("armeria-heapdump-executor", true));
    }

    private static class HeapDumper {
        private final Object diagnosticMXBean;
        private final MethodHandle dumpHeapMH;

        HeapDumper() {
            try {
                Class<?> diagnosticMXBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                this.diagnosticMXBean = ManagementFactory.getPlatformMXBean(diagnosticMXBeanClass);
                MethodType methodType = MethodType.methodType(Void.TYPE, String.class, Boolean.TYPE);
                this.dumpHeapMH = MethodHandles.publicLookup().findVirtual(diagnosticMXBeanClass, "dumpHeap", methodType);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Unable to locate HotSpotDiagnosticMXBean", ex);
            }
        }

        void dumpHeap(File file, boolean live) throws Throwable {
            this.dumpHeapMH.invoke(this.diagnosticMXBean, file.getAbsolutePath(), live);
        }
    }
}

