/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource.etree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.ripe.ipresource.etree.ChildNodeMap;
import net.ripe.ipresource.etree.InternalNode;
import net.ripe.ipresource.etree.IntervalStrategy;
import net.ripe.ipresource.etree.OverlappingIntervalException;

class ChildNodeTreeMap<K, V>
extends TreeMap<K, InternalNode<K, V>>
implements ChildNodeMap<K, V> {
    private static final long serialVersionUID = 1L;
    static final ChildNodeMap EMPTY = new Empty();

    static <K, T> ChildNodeMap<K, T> empty() {
        return EMPTY;
    }

    ChildNodeTreeMap(IntervalStrategy<K> strategy) {
        super(strategy.upperBoundComparator());
    }

    public ChildNodeTreeMap(ChildNodeMap<K, V> source, IntervalStrategy<K> strategy) {
        this(strategy);
        for (InternalNode<K, V> node : source.values()) {
            this.put(node.getKey(), new InternalNode<K, V>(node, strategy));
        }
    }

    @Override
    public void addChild(InternalNode<K, V> nodeToAdd, IntervalStrategy<K> strategy) {
        K range = nodeToAdd.getKey();
        InternalNode<K, V> containingChild = this.getChildContaining(range, strategy);
        if (containingChild != null) {
            containingChild.addChild(nodeToAdd, strategy);
            return;
        }
        List<K> overlaps = this.getOverlappingChildren(range, strategy);
        if (!overlaps.isEmpty()) {
            throw new OverlappingIntervalException(range, overlaps);
        }
        this.transferChildNodes(nodeToAdd, strategy);
        this.put(range, nodeToAdd);
    }

    private void transferChildNodes(InternalNode<K, V> nodeToAdd, IntervalStrategy<K> strategy) {
        InternalNode child;
        K range = nodeToAdd.getKey();
        Iterator it = this.tailMap(strategy.singletonIntervalAtLowerBound(range)).values().iterator();
        while (it.hasNext() && strategy.contains(range, (child = (InternalNode)it.next()).getKey())) {
            nodeToAdd.addChild(child, strategy);
            it.remove();
        }
    }

    @Override
    public void removeChild(K interval, IntervalStrategy<K> strategy) {
        InternalNode<K, V> containing = this.getChildContaining(interval, strategy);
        if (containing == null) {
            return;
        }
        if (interval.equals(containing.getKey())) {
            this.remove(interval);
            for (InternalNode<K, V> node : containing.getChildren().values()) {
                this.put(node.getKey(), node);
            }
        } else {
            containing.removeChild(interval, strategy);
        }
    }

    private List<K> getOverlappingChildren(K range, IntervalStrategy<K> strategy) {
        K upperCandidate;
        List result = Collections.emptyList();
        K lowerCandidate = this.ceilingKey(strategy.singletonIntervalAtLowerBound(range));
        if (lowerCandidate != null && this.overlapsButNotContained(range, lowerCandidate, strategy)) {
            result = new ArrayList(result);
            result.add(lowerCandidate);
        }
        if ((upperCandidate = this.ceilingKey(range)) != null && this.overlapsButNotContained(range, upperCandidate, strategy)) {
            result = new ArrayList(result);
            result.add(upperCandidate);
        }
        return result;
    }

    private boolean overlapsButNotContained(K left, K right, IntervalStrategy<K> strategy) {
        return strategy.overlaps(left, right) && !strategy.contains(left, right) && !strategy.contains(right, left);
    }

    private InternalNode<K, V> getChildContaining(K range, IntervalStrategy<K> strategy) {
        Map.Entry entry = this.ceilingEntry(strategy.singletonIntervalAtLowerBound(range));
        if (entry != null && strategy.contains(entry.getKey(), range)) {
            return (InternalNode)entry.getValue();
        }
        return null;
    }

    @Override
    public void findExactAndAllLessSpecific(List<InternalNode<K, V>> result, K range, IntervalStrategy<K> strategy) {
        InternalNode<K, V> node = this.getChildContaining(range, strategy);
        if (node != null) {
            result.add(node);
            node.getChildren().findExactAndAllLessSpecific(result, range, strategy);
        }
    }

    @Override
    public void findExactAndAllMoreSpecific(List<InternalNode<K, V>> result, K range, IntervalStrategy<K> strategy) {
        for (InternalNode node : this.tailMap(strategy.singletonIntervalAtLowerBound(range)).values()) {
            if (strategy.contains(range, node.getKey())) {
                result.add(node);
                node.getChildren().addAllChildrenToList(result, strategy);
                continue;
            }
            if (!strategy.overlaps(range, node.getKey())) break;
            node.getChildren().findExactAndAllMoreSpecific(result, range, strategy);
        }
    }

    @Override
    public void findFirstMoreSpecific(List<InternalNode<K, V>> result, K range, IntervalStrategy<K> strategy) {
        for (InternalNode node : this.tailMap(strategy.singletonIntervalAtLowerBound(range)).values()) {
            if (strategy.contains(range, node.getKey())) {
                result.add(node);
                continue;
            }
            if (!strategy.overlaps(range, node.getKey())) break;
            node.getChildren().findFirstMoreSpecific(result, range, strategy);
        }
    }

    @Override
    public void addAllChildrenToList(List<InternalNode<K, V>> list, IntervalStrategy<K> strategy) {
        for (InternalNode node : this.values()) {
            list.add(node);
            node.getChildren().addAllChildrenToList(list, strategy);
        }
    }

    private static final class Empty
    extends TreeMap
    implements ChildNodeMap {
        private static final long serialVersionUID = 1L;

        private Empty() {
        }

        public void addChild(InternalNode childToAdd, IntervalStrategy strategy) {
            throw new UnsupportedOperationException();
        }

        public void removeChild(Object interval, IntervalStrategy strategy) {
            throw new UnsupportedOperationException();
        }

        public void findExactAndAllLessSpecific(List list, Object range, IntervalStrategy strategy) {
        }

        public void findExactAndAllMoreSpecific(List list, Object range, IntervalStrategy strategy) {
        }

        public void findFirstMoreSpecific(List list, Object interval, IntervalStrategy strategy) {
        }

        public void addAllChildrenToList(List list, IntervalStrategy strategy) {
        }
    }
}

