/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.proxy;

import com.linecorp.armeria.client.proxy.ProxyConfig;
import com.linecorp.armeria.client.proxy.ProxyType;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.net.InetSocketAddress;
import java.util.Objects;

public final class ConnectProxyConfig
extends ProxyConfig {
    private final InetSocketAddress proxyAddress;
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    private final HttpHeaders headers;
    private final boolean useTls;

    ConnectProxyConfig(InetSocketAddress proxyAddress, @Nullable String username, @Nullable String password, HttpHeaders headers, boolean useTls) {
        this.proxyAddress = proxyAddress;
        this.username = username;
        this.password = password;
        this.headers = headers;
        this.useTls = useTls;
    }

    @Override
    public InetSocketAddress proxyAddress() {
        return this.proxyAddress;
    }

    @Nullable
    public String username() {
        return this.username;
    }

    @Nullable
    public String password() {
        return this.password;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public boolean useTls() {
        return this.useTls;
    }

    @Override
    public ProxyType proxyType() {
        return ProxyType.CONNECT;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectProxyConfig)) {
            return false;
        }
        ConnectProxyConfig that = (ConnectProxyConfig)o;
        return this.useTls == that.useTls && this.proxyAddress.equals(that.proxyAddress) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && this.headers.equals(that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.proxyAddress, this.username, this.password, this.headers, this.useTls);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("proxyType", (Object)this.proxyType()).add("proxyAddress", this.proxyAddress()).add("username", this.username()).add("password", ConnectProxyConfig.maskPassword(this.username(), this.password())).add("useTls", this.useTls()).toString();
    }
}

