/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid.j2d;

import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import org.apache.sis.coverage.grid.j2d.RasterFactory;

final class MultiBandsIndexColorModel
extends IndexColorModel {
    final int numBands;
    final int visibleBand;

    public MultiBandsIndexColorModel(int bits, int size, int[] cmap, int start, boolean hasAlpha, int transparent, int transferType, int numBands, int visibleBand) {
        super(bits, size, cmap, start, hasAlpha, transparent, transferType);
        this.numBands = numBands;
        this.visibleBand = visibleBand;
    }

    final IndexColorModel derive(int numBands, int visibleBand) {
        if (numBands == this.numBands && visibleBand == this.visibleBand) {
            return this;
        }
        int[] cmap = this.getARGB();
        boolean hasAlpha = this.hasAlpha();
        int transparent = this.getTransparentPixel();
        if (numBands == 1) {
            return new IndexColorModel(this.pixel_bits, cmap.length, cmap, 0, hasAlpha, transparent, this.transferType);
        }
        return new MultiBandsIndexColorModel(this.pixel_bits, cmap.length, cmap, 0, hasAlpha, transparent, this.transferType, numBands, visibleBand);
    }

    private int[] getARGB() {
        int[] cmap = new int[this.getMapSize()];
        for (int i = 0; i < cmap.length; ++i) {
            cmap[i] = this.getRGB(i);
        }
        return cmap;
    }

    @Override
    public Object getDataElements(int RGB, Object pixel) {
        if (pixel == null) {
            switch (this.transferType) {
                case 1: 
                case 2: {
                    pixel = new short[this.numBands];
                    break;
                }
                case 0: {
                    pixel = new byte[this.numBands];
                    break;
                }
                case 3: {
                    pixel = new int[this.numBands];
                }
            }
        }
        pixel = super.getDataElements(RGB, pixel);
        switch (this.transferType) {
            case 0: {
                byte[] array = (byte[])pixel;
                Arrays.fill(array, 1, this.numBands, array[0]);
                break;
            }
            case 1: 
            case 2: {
                short[] array = (short[])pixel;
                Arrays.fill(array, 1, this.numBands, array[0]);
                break;
            }
            case 3: {
                int[] array = (int[])pixel;
                Arrays.fill(array, 1, this.numBands, array[0]);
                break;
            }
        }
        return pixel;
    }

    private int pixel(Object inData) {
        switch (this.transferType) {
            case 0: {
                return Byte.toUnsignedInt(((byte[])inData)[this.visibleBand]);
            }
            case 1: {
                return Short.toUnsignedInt(((short[])inData)[this.visibleBand]);
            }
            case 2: {
                return ((short[])inData)[this.visibleBand];
            }
            case 3: {
                return ((int[])inData)[this.visibleBand];
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPixelSize() {
        return this.pixel_bits * this.numBands;
    }

    @Override
    public int[] getComponents(Object pixel, int[] components, int offset) {
        return this.getComponents(this.pixel(components), components, offset);
    }

    @Override
    public int getRed(Object inData) {
        return this.getRed(this.pixel(inData));
    }

    @Override
    public int getGreen(Object inData) {
        return this.getGreen(this.pixel(inData));
    }

    @Override
    public int getBlue(Object inData) {
        return this.getBlue(this.pixel(inData));
    }

    @Override
    public int getAlpha(Object inData) {
        return this.getAlpha(this.pixel(inData));
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int width, int height) {
        return Raster.createWritableRaster(this.createCompatibleSampleModel(width, height), null);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int width, int height) {
        SampleModel sm;
        if (this.pixel_bits <= DataBuffer.getDataTypeSize(this.transferType) / this.numBands) {
            int[] bitMasks = new int[this.numBands];
            Arrays.fill(bitMasks, this.pixel_bits);
            sm = new SinglePixelPackedSampleModel(this.transferType, width, height, width, bitMasks);
        } else {
            sm = new BandedSampleModel(this.transferType, width, height, this.numBands);
        }
        return RasterFactory.unique(sm);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        return this.isCompatibleSampleModel(raster.getSampleModel());
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sm) {
        return (sm instanceof ComponentSampleModel || sm instanceof SinglePixelPackedSampleModel) && sm.getTransferType() == this.transferType && sm.getNumBands() == this.numBands && 1 << sm.getSampleSize(this.visibleBand) >= this.getMapSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MultiBandsIndexColorModel) {
            MultiBandsIndexColorModel other = (MultiBandsIndexColorModel)obj;
            return this.numBands == other.numBands && this.visibleBand == other.visibleBand && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * this.numBands + 37 * this.visibleBand;
    }
}

