/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Collection;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.sql.feature.BinaryEncoding;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.internal.UnmodifiableArrayList;

public class ValueGetter<T> {
    static final ValueGetter<LocalDate> LOCAL_DATE = new ValueGetter<LocalDate>(LocalDate.class);
    static final ValueGetter<LocalTime> LOCAL_TIME = new ValueGetter<LocalTime>(LocalTime.class);
    static final ValueGetter<LocalDateTime> LOCAL_DATE_TIME = new ValueGetter<LocalDateTime>(LocalDateTime.class);
    static final ValueGetter<OffsetTime> OFFSET_TIME = new ValueGetter<OffsetTime>(OffsetTime.class);
    static final ValueGetter<OffsetDateTime> OFFSET_DATE_TIME = new ValueGetter<OffsetDateTime>(OffsetDateTime.class);
    protected final Class<? extends T> valueType;

    protected ValueGetter(Class<? extends T> valueType) {
        ArgumentChecks.ensureNonNull((String)"valueType", valueType);
        this.valueType = valueType;
    }

    public T getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws Exception {
        return source.getObject(columnIndex, this.valueType);
    }

    protected static Collection<?> toCollection(InfoStatements stmts, ValueGetter<?> cmget, java.sql.Array array) throws Exception {
        if (array == null) {
            return null;
        }
        Object result = array.getArray();
        if (cmget == null && stmts != null) {
            cmget = stmts.getComponentMapping(array);
        }
        Class componentType = Numbers.primitiveToWrapper(result.getClass().getComponentType());
        if (cmget != null && !cmget.valueType.isAssignableFrom(componentType)) {
            componentType = Numbers.wrapperToPrimitive(cmget.valueType);
            int length = Array.getLength(result);
            result = Array.newInstance(componentType, length);
            try (ResultSet r = array.getResultSet();){
                while (r.next()) {
                    Array.set(result, r.getInt(1) - 1, cmget.getValue(stmts, r, 2));
                }
            }
        }
        array.free();
        if (Numbers.isNumber((Class)componentType)) {
            return Vector.create((Object)result, (boolean)true);
        }
        return UnmodifiableArrayList.wrap((Object[])((Object[])result));
    }

    static final class AsArray
    extends ValueGetter<Collection<?>> {
        public final ValueGetter<?> cmget;
        public static final AsArray INSTANCE = new AsArray(null);

        AsArray(ValueGetter<?> cmget) {
            super(Collection.class);
            this.cmget = cmget;
        }

        @Override
        public Collection<?> getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws Exception {
            return AsArray.toCollection(stmts, this.cmget, source.getArray(columnIndex));
        }
    }

    static final class AsOffsetTime
    extends ValueGetter<OffsetTime> {
        public static final AsOffsetTime INSTANCE = new AsOffsetTime();

        private AsOffsetTime() {
            super(OffsetTime.class);
        }

        @Override
        public OffsetTime getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            Time time = source.getTime(columnIndex);
            if (time == null) {
                return null;
            }
            int offsetMinute = -time.getTimezoneOffset();
            int milli = (int)(time.getTime() % 1000L);
            return time.toLocalTime().withNano(milli * 1000000).atOffset(ZoneOffset.ofHoursMinutes(offsetMinute / 60, offsetMinute % 60));
        }
    }

    static final class AsOffsetDateTime
    extends ValueGetter<OffsetDateTime> {
        public static final AsOffsetDateTime INSTANCE = new AsOffsetDateTime();

        private AsOffsetDateTime() {
            super(OffsetDateTime.class);
        }

        @Override
        public OffsetDateTime getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            Timestamp time = source.getTimestamp(columnIndex);
            if (time == null) {
                return null;
            }
            int offsetMinute = -time.getTimezoneOffset();
            return time.toInstant().atOffset(ZoneOffset.ofHoursMinutes(offsetMinute / 60, offsetMinute % 60));
        }
    }

    static final class AsLocalDateTime
    extends ValueGetter<LocalDateTime> {
        public static final AsLocalDateTime INSTANCE = new AsLocalDateTime();

        private AsLocalDateTime() {
            super(LocalDateTime.class);
        }

        @Override
        public LocalDateTime getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            Timestamp time = source.getTimestamp(columnIndex);
            return time != null ? time.toLocalDateTime() : null;
        }
    }

    static final class AsLocalTime
    extends ValueGetter<LocalTime> {
        public static final AsLocalTime INSTANCE = new AsLocalTime();

        private AsLocalTime() {
            super(LocalTime.class);
        }

        @Override
        public LocalTime getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            Time time = source.getTime(columnIndex);
            if (time == null) {
                return null;
            }
            int milli = (int)(time.getTime() % 1000L);
            return time.toLocalTime().withNano(milli * 1000000);
        }
    }

    static final class AsLocalDate
    extends ValueGetter<LocalDate> {
        public static final AsLocalDate INSTANCE = new AsLocalDate();

        private AsLocalDate() {
            super(LocalDate.class);
        }

        @Override
        public LocalDate getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            Date date = source.getDate(columnIndex);
            return date != null ? date.toLocalDate() : null;
        }
    }

    static final class AsBoolean
    extends ValueGetter<Boolean> {
        public static final AsBoolean INSTANCE = new AsBoolean();

        private AsBoolean() {
            super(Boolean.class);
        }

        @Override
        public Boolean getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            boolean value = source.getBoolean(columnIndex);
            return source.wasNull() ? null : Boolean.valueOf(value);
        }
    }

    static final class AsBigDecimal
    extends ValueGetter<BigDecimal> {
        public static final AsBigDecimal INSTANCE = new AsBigDecimal();

        private AsBigDecimal() {
            super(BigDecimal.class);
        }

        @Override
        public BigDecimal getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            return source.getBigDecimal(columnIndex);
        }
    }

    static final class AsDouble
    extends ValueGetter<Double> {
        public static final AsDouble INSTANCE = new AsDouble();

        private AsDouble() {
            super(Double.class);
        }

        @Override
        public Double getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            double value = source.getDouble(columnIndex);
            return source.wasNull() ? null : Double.valueOf(value);
        }
    }

    static final class AsFloat
    extends ValueGetter<Float> {
        public static final AsFloat INSTANCE = new AsFloat();

        private AsFloat() {
            super(Float.class);
        }

        @Override
        public Float getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            float value = source.getFloat(columnIndex);
            return source.wasNull() ? null : Float.valueOf(value);
        }
    }

    static final class AsLong
    extends ValueGetter<Long> {
        public static final AsLong INSTANCE = new AsLong();

        private AsLong() {
            super(Long.class);
        }

        @Override
        public Long getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            long value = source.getLong(columnIndex);
            return source.wasNull() ? null : Long.valueOf(value);
        }
    }

    static final class AsInteger
    extends ValueGetter<Integer> {
        public static final AsInteger INSTANCE = new AsInteger();

        private AsInteger() {
            super(Integer.class);
        }

        @Override
        public Integer getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            int value = source.getInt(columnIndex);
            return source.wasNull() ? null : Integer.valueOf(value);
        }
    }

    static final class AsShort
    extends ValueGetter<Short> {
        public static final AsShort INSTANCE = new AsShort();

        private AsShort() {
            super(Short.class);
        }

        @Override
        public Short getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            short value = source.getShort(columnIndex);
            return source.wasNull() ? null : Short.valueOf(value);
        }
    }

    static final class AsByte
    extends ValueGetter<Byte> {
        public static final AsByte INSTANCE = new AsByte();

        private AsByte() {
            super(Byte.class);
        }

        @Override
        public Byte getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            byte value = source.getByte(columnIndex);
            return source.wasNull() ? null : Byte.valueOf(value);
        }
    }

    static final class AsBytes
    extends ValueGetter<byte[]> {
        private final BinaryEncoding encoding;
        public static final AsBytes INSTANCE = new AsBytes(BinaryEncoding.RAW);
        public static final AsBytes HEXADECIMAL = new AsBytes(BinaryEncoding.HEXADECIMAL);

        private AsBytes(BinaryEncoding encoding) {
            super(byte[].class);
            this.encoding = encoding;
        }

        @Override
        public byte[] getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            return this.encoding.getBytes(source, columnIndex);
        }
    }

    static final class AsString
    extends ValueGetter<String> {
        public static final AsString INSTANCE = new AsString();

        private AsString() {
            super(String.class);
        }

        @Override
        public String getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws SQLException {
            return source.getString(columnIndex);
        }
    }

    static final class AsObject
    extends ValueGetter<Object> {
        public static final AsObject INSTANCE = new AsObject();

        private AsObject() {
            super(Object.class);
        }

        @Override
        public Object getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws Exception {
            Collection<?> value = source.getObject(columnIndex);
            if (value instanceof java.sql.Array) {
                value = AsObject.toCollection(stmts, null, (java.sql.Array)((Object)value));
            }
            return value;
        }
    }
}

