/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageManager;
import mil.nga.geopackage.io.TileFormatType;
import mil.nga.geopackage.io.TileProperties;
import mil.nga.geopackage.tiles.GeoPackageTile;
import mil.nga.geopackage.tiles.GeoPackageTileRetriever;
import mil.nga.geopackage.tiles.ImageUtils;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.user.TileDao;
import mil.nga.geopackage.tiles.user.TileResultSet;
import mil.nga.geopackage.tiles.user.TileRow;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionFactory;
import mil.nga.sf.proj.GeometryTransform;
import org.locationtech.proj4j.units.Units;

public class TileWriter {
    public static final String ARGUMENT_PREFIX = "-";
    public static final String ARGUMENT_TILE_TYPE = "t";
    public static final String ARGUMENT_IMAGE_FORMAT = "i";
    public static final String ARGUMENT_RAW_IMAGE = "r";
    public static final String ARGUMENT_IMAGE_WIDTH = "w";
    public static final String ARGUMENT_IMAGE_HEIGHT = "h";
    public static final TileFormatType DEFAULT_TILE_TYPE = TileFormatType.XYZ;
    public static final String DEFAULT_IMAGE_FORMAT = "png";
    private static final Logger LOGGER = Logger.getLogger(TileWriter.class.getName());
    private static final int ZOOM_PROGRESS_FREQUENCY = 100;

    public static void main(String[] args) throws Exception {
        boolean valid = true;
        boolean requiredArguments = false;
        TileFormatType tileType = null;
        String imageFormat = null;
        boolean rawImage = false;
        File geoPackageFile = null;
        String tileTable = null;
        File outputDirectory = null;
        Integer width = null;
        Integer height = null;
        for (int i = 0; valid && i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith(ARGUMENT_PREFIX)) {
                String argument;
                switch (argument = arg.substring(ARGUMENT_PREFIX.length())) {
                    case "t": {
                        if (i + 1 < args.length) {
                            String tiletypeString = args[++i].toUpperCase();
                            try {
                                tileType = TileFormatType.valueOf(tiletypeString);
                            }
                            catch (IllegalArgumentException e) {
                                valid = false;
                                System.out.println("Error: Image Tile Type argument '" + arg + "' must be followed by a valid tile format type. Invalid: " + tiletypeString);
                            }
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Tile Type argument '" + arg + "' must be followed by a tile type (geopackage, standard, tms)");
                        break;
                    }
                    case "i": {
                        if (i + 1 < args.length) {
                            imageFormat = args[++i];
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Image Format argument '" + arg + "' must be followed by a image format");
                        break;
                    }
                    case "r": {
                        rawImage = true;
                        break;
                    }
                    case "w": {
                        if (i + 1 < args.length) {
                            String widthString = args[++i];
                            try {
                                width = Integer.valueOf(widthString);
                            }
                            catch (NumberFormatException e) {
                                valid = false;
                                System.out.println("Error: Image Width argument '" + arg + "' must be followed by a valid width in pixels. Invalid: " + widthString);
                            }
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Image Width argument '" + arg + "' must be followed by a image width in pixels");
                        break;
                    }
                    case "h": {
                        if (i + 1 < args.length) {
                            String heightString = args[++i];
                            try {
                                height = Integer.valueOf(heightString);
                            }
                            catch (NumberFormatException e) {
                                valid = false;
                                System.out.println("Error: Image Height argument '" + arg + "' must be followed by a valid height in pixels. Invalid: " + heightString);
                            }
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Image Height argument '" + arg + "' must be followed by a height width in pixels");
                        break;
                    }
                    default: {
                        valid = false;
                        System.out.println("Error: Unsupported arg: '" + arg + "'");
                    }
                }
                continue;
            }
            if (geoPackageFile == null) {
                geoPackageFile = new File(arg);
                continue;
            }
            if (tileTable == null) {
                tileTable = arg;
                continue;
            }
            if (outputDirectory == null) {
                outputDirectory = new File(arg);
                requiredArguments = true;
                continue;
            }
            valid = false;
            System.out.println("Error: Unsupported extra argument: " + arg);
        }
        if (!valid || !requiredArguments) {
            TileWriter.printUsage();
        } else {
            try {
                TileWriter.writeTiles(geoPackageFile, tileTable, outputDirectory, imageFormat, width, height, tileType, rawImage);
            }
            catch (Exception e) {
                TileWriter.printUsage();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTiles(File geoPackageFile, String tileTable, File directory, String imageFormat, Integer width, Integer height, TileFormatType tileType, boolean rawImage) throws IOException {
        try (GeoPackage geoPackage = GeoPackageManager.open(geoPackageFile);){
            TileWriter.writeTiles(geoPackage, tileTable, directory, imageFormat, width, height, tileType, rawImage);
        }
    }

    public static void writeTiles(GeoPackage geoPackage, String tileTable, File directory, String imageFormat, Integer width, Integer height, TileFormatType tileType, boolean rawImage) throws IOException {
        TileDao tileDao = geoPackage.getTileDao(tileTable);
        if (imageFormat == null) {
            imageFormat = DEFAULT_IMAGE_FORMAT;
        }
        if (tileType == null) {
            tileType = DEFAULT_TILE_TYPE;
        }
        LOGGER.log(Level.INFO, "GeoPackage: " + geoPackage.getName() + ", Tile Table: " + tileTable + ", Output Directory: " + directory + (rawImage ? ", Raw Images" : "") + ", Image Format: " + imageFormat + ", Image Width: " + width + ", Image Height: " + height + ", Tiles Type: " + tileType + ", Tile Zoom Range: " + tileDao.getMinZoom() + " - " + tileDao.getMaxZoom());
        int totalCount = 0;
        switch (tileType) {
            case GEOPACKAGE: {
                totalCount = TileWriter.writeGeoPackageFormatTiles(tileDao, directory, imageFormat, width, height, rawImage);
                break;
            }
            case XYZ: 
            case TMS: {
                totalCount = TileWriter.writeFormatTiles(tileDao, directory, imageFormat, width, height, tileType, rawImage);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Tile Type Not Supported: " + tileType);
            }
        }
        if (tileType == TileFormatType.GEOPACKAGE) {
            tileDao = geoPackage.getTileDao(tileTable);
            TileProperties tileProperties = new TileProperties(directory);
            tileProperties.writeFile(tileDao);
        }
        LOGGER.log(Level.INFO, "Total Tiles: " + totalCount);
    }

    private static int writeGeoPackageFormatTiles(TileDao tileDao, File directory, String imageFormat, Integer width, Integer height, boolean rawImage) throws IOException {
        int tileCount = 0;
        for (long zoomLevel = tileDao.getMinZoom(); zoomLevel <= tileDao.getMaxZoom(); ++zoomLevel) {
            TileMatrix tileMatrix = tileDao.getTileMatrix(zoomLevel);
            LOGGER.log(Level.INFO, "Zoom Level: " + zoomLevel + ", Width: " + tileMatrix.getMatrixWidth() + ", Height: " + tileMatrix.getMatrixHeight() + ", Max Tiles: " + tileMatrix.getMatrixWidth() * tileMatrix.getMatrixHeight());
            File zDirectory = new File(directory, String.valueOf(zoomLevel));
            int zoomCount = 0;
            TileResultSet tileResultSet = tileDao.queryForTile(zoomLevel);
            while (tileResultSet.moveToNext()) {
                byte[] tileData;
                TileRow tileRow = (TileRow)tileResultSet.getRow();
                if (tileRow == null || (tileData = tileRow.getTileData()) == null) continue;
                File xDirectory = new File(zDirectory, String.valueOf(tileRow.getTileColumn()));
                xDirectory.mkdirs();
                File imageFile = new File(xDirectory, String.valueOf(tileRow.getTileRow()) + "." + imageFormat);
                if (rawImage) {
                    FileOutputStream fos = new FileOutputStream(imageFile);
                    fos.write(tileData);
                    fos.close();
                } else {
                    BufferedImage tileImage = tileRow.getTileDataImage();
                    int tileWidth = width != null ? width.intValue() : tileImage.getWidth();
                    int tileHeight = height != null ? height.intValue() : tileImage.getHeight();
                    Image drawImage = null;
                    drawImage = tileImage.getWidth() != tileWidth || tileImage.getHeight() != tileHeight ? tileImage.getScaledInstance(tileWidth, tileHeight, 4) : tileImage;
                    BufferedImage image = ImageUtils.createBufferedImage(tileWidth, tileHeight, imageFormat);
                    Graphics graphics = image.getGraphics();
                    graphics.drawImage(drawImage, 0, 0, null);
                    ImageIO.write((RenderedImage)image, imageFormat, imageFile);
                }
                if (++zoomCount % 100 != 0) continue;
                LOGGER.log(Level.INFO, "Zoom " + zoomLevel + " Tile Progress... " + zoomCount);
            }
            tileResultSet.close();
            LOGGER.log(Level.INFO, "Zoom " + zoomLevel + " Tiles: " + zoomCount);
            tileCount += zoomCount;
        }
        return tileCount;
    }

    private static int writeFormatTiles(TileDao tileDao, File directory, String imageFormat, Integer width, Integer height, TileFormatType tileType, boolean rawImage) throws IOException {
        int tileCount = 0;
        Projection projection = tileDao.getProjection();
        Projection webMercator = ProjectionFactory.getProjection((long)3857L);
        GeometryTransform projectionToWebMercator = GeometryTransform.create((Projection)projection, (Projection)webMercator);
        BoundingBox zoomBoundingBox = tileDao.getBoundingBox();
        if (projection.isUnit(Units.DEGREES)) {
            zoomBoundingBox = TileBoundingBoxUtils.boundDegreesBoundingBoxWithWebMercatorLimits((BoundingBox)zoomBoundingBox);
        }
        BoundingBox zoomWebMercatorBoundingBox = zoomBoundingBox.transform(projectionToWebMercator);
        GeoPackageTileRetriever retriever = null;
        retriever = rawImage ? new GeoPackageTileRetriever(tileDao) : new GeoPackageTileRetriever(tileDao, width, height, imageFormat);
        double maxLength = tileDao.getMaxLength();
        double minLength = tileDao.getMinLength();
        double upperMax = TileWriter.getLength(new BoundingBox(zoomBoundingBox.getMinLongitude(), zoomBoundingBox.getMaxLatitude() - maxLength, zoomBoundingBox.getMinLongitude() + maxLength, zoomBoundingBox.getMaxLatitude()), projectionToWebMercator);
        double upperMin = TileWriter.getLength(new BoundingBox(zoomBoundingBox.getMinLongitude(), zoomBoundingBox.getMaxLatitude() - minLength, zoomBoundingBox.getMinLongitude() + minLength, zoomBoundingBox.getMaxLatitude()), projectionToWebMercator);
        double lowerMax = TileWriter.getLength(new BoundingBox(zoomBoundingBox.getMinLongitude(), zoomBoundingBox.getMinLatitude(), zoomBoundingBox.getMinLongitude() + maxLength, zoomBoundingBox.getMinLatitude() + maxLength), projectionToWebMercator);
        double lowerMin = TileWriter.getLength(new BoundingBox(zoomBoundingBox.getMinLongitude(), zoomBoundingBox.getMinLatitude(), zoomBoundingBox.getMinLongitude() + minLength, zoomBoundingBox.getMinLatitude() + minLength), projectionToWebMercator);
        double maxWebMercatorLength = Math.max(upperMax, lowerMax);
        double minWebMercatorLength = Math.min(upperMin, lowerMin);
        double minZoom = TileBoundingBoxUtils.zoomLevelOfTileSize((double)maxWebMercatorLength);
        double maxZoom = TileBoundingBoxUtils.zoomLevelOfTileSize((double)minWebMercatorLength);
        int minZoomCeiling = (int)Math.ceil(minZoom);
        int maxZoomFloor = (int)Math.floor(maxZoom);
        LOGGER.log(Level.INFO, tileType + " Zoom Range: " + minZoomCeiling + " - " + maxZoomFloor);
        for (int zoomLevel = minZoomCeiling; zoomLevel <= maxZoomFloor; ++zoomLevel) {
            File zDirectory = new File(directory, String.valueOf(zoomLevel));
            TileGrid tileGrid = TileBoundingBoxUtils.getTileGrid((BoundingBox)zoomWebMercatorBoundingBox, (long)zoomLevel);
            int zoomCount = 0;
            LOGGER.log(Level.INFO, "Zoom Level: " + zoomLevel + ", Min X: " + tileGrid.getMinX() + ", Max X: " + tileGrid.getMaxX() + ", Min Y: " + tileGrid.getMinY() + ", Max Y: " + tileGrid.getMaxY() + ", Max Tiles: " + tileGrid.count());
            for (long x = tileGrid.getMinX(); x <= tileGrid.getMaxX(); ++x) {
                File xDirectory = new File(zDirectory, String.valueOf(x));
                for (long y = tileGrid.getMinY(); y <= tileGrid.getMaxY(); ++y) {
                    GeoPackageTile geoPackageTile = retriever.getTile((int)x, (int)y, zoomLevel);
                    if (geoPackageTile == null) continue;
                    long yFileName = y;
                    if (tileType == TileFormatType.TMS) {
                        yFileName = TileBoundingBoxUtils.getYAsOppositeTileFormat((long)zoomLevel, (int)((int)y));
                    }
                    File imageFile = new File(xDirectory, String.valueOf(yFileName) + "." + imageFormat);
                    xDirectory.mkdirs();
                    if (geoPackageTile.getImage() != null) {
                        ImageIO.write((RenderedImage)geoPackageTile.getImage(), imageFormat, imageFile);
                    } else {
                        FileOutputStream fos = new FileOutputStream(imageFile);
                        fos.write(geoPackageTile.getData());
                        fos.close();
                    }
                    if (++zoomCount % 100 != 0) continue;
                    LOGGER.log(Level.INFO, "Zoom " + zoomLevel + " Tile Progress... " + zoomCount);
                }
            }
            LOGGER.log(Level.INFO, "Zoom " + zoomLevel + " Tiles: " + zoomCount);
            tileCount += zoomCount;
        }
        return tileCount;
    }

    private static double getLength(BoundingBox boundingBox, GeometryTransform toWebMercatorTransform) {
        BoundingBox transformedBoundingBox = boundingBox.transform(toWebMercatorTransform);
        return TileWriter.getLength(transformedBoundingBox);
    }

    private static double getLength(BoundingBox boundingBox) {
        double width = boundingBox.getMaxLongitude() - boundingBox.getMinLongitude();
        double height = boundingBox.getMaxLatitude() - boundingBox.getMinLatitude();
        double length = Math.min(width, height);
        return length;
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("USAGE");
        System.out.println();
        System.out.println("\t[-t tile_type] [-i image_format] [-r] geopackage_file tile_table output_directory");
        System.out.println();
        System.out.println("DESCRIPTION");
        System.out.println();
        System.out.println("\tWrites a tile set from within a GeoPackage tile table to the file system in a z/x/y folder system according to the specified tile type");
        System.out.println();
        System.out.println("ARGUMENTS");
        System.out.println();
        System.out.println("\t-t tile_type");
        System.out.println("\t\tTile output format specifying z/x/y folder organization: " + TileFormatType.GEOPACKAGE.name().toLowerCase() + ", " + TileFormatType.XYZ.name().toLowerCase() + ", " + TileFormatType.TMS.name().toLowerCase() + " (Default is " + DEFAULT_TILE_TYPE.name().toLowerCase() + ")");
        System.out.println("\t\t\t" + TileFormatType.GEOPACKAGE.name().toLowerCase() + " - x and y represent GeoPackage Tile Matrix width and height");
        System.out.println("\t\t\t" + TileFormatType.XYZ.name().toLowerCase() + " - x and y origin is top left");
        System.out.println("\t\t\t" + TileFormatType.TMS.name().toLowerCase() + " - (Tile Map Service) x and y origin is bottom left");
        System.out.println();
        System.out.println("\t-i image_format");
        System.out.println("\t\tOutput image format: png, jpg, jpeg (default is 'png')");
        System.out.println();
        System.out.println("\t-w image_width");
        System.out.println("\t\tOutput image width in pixels (default is GeoPackage tile width)");
        System.out.println();
        System.out.println("\t-h image_height");
        System.out.println("\t\tOutput image height in pixels (default is GeoPackage tile height)");
        System.out.println();
        System.out.println("\t-r");
        System.out.println("\t\tUse the raw image bytes, only works when combining and cropping is not required");
        System.out.println();
        System.out.println("\tgeopackage_file");
        System.out.println("\t\tpath to the GeoPackage file containing the tiles");
        System.out.println();
        System.out.println("\ttile_table");
        System.out.println("\t\ttile table name within the GeoPackage file");
        System.out.println();
        System.out.println("\toutput_directory");
        System.out.println("\t\toutput directory to write the tile images to");
        System.out.println();
    }
}

