/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.common;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import mil.nga.crs.common.Identifiable;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.common.UnitType;
import mil.nga.crs.wkt.CRSWriter;

public class Unit
implements Identifiable {
    private static final Logger logger = Logger.getLogger(Unit.class.getName());
    private UnitType type = null;
    private String name = null;
    private Double conversionFactor;
    private String conversionFactorText;
    private List<Identifier> identifiers = null;

    public Unit() {
    }

    public Unit(UnitType type, String name) {
        this.setType(type);
        this.setName(name);
    }

    public Unit(UnitType type, String name, double conversionFactor) {
        this.setType(type);
        this.setName(name);
        this.setConversionFactor(conversionFactor);
    }

    public Unit(UnitType type, String name, String conversionFactor) {
        this.setType(type);
        this.setName(name);
        this.setConversionFactor(conversionFactor);
    }

    public UnitType getType() {
        return this.type;
    }

    public void setType(UnitType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getConversionFactor() {
        return this.conversionFactor;
    }

    public String getConversionFactorText() {
        return this.conversionFactorText;
    }

    public boolean hasConversionFactor() {
        return this.getConversionFactor() != null;
    }

    public void setConversionFactor(Double conversionFactor) {
        this.conversionFactor = conversionFactor;
        this.conversionFactorText = conversionFactor != null ? String.valueOf(conversionFactor) : null;
    }

    public void setConversionFactor(String conversionFactor) {
        this.conversionFactorText = conversionFactor;
        this.conversionFactor = conversionFactor != null ? Double.valueOf(Double.parseDouble(conversionFactor)) : null;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public boolean hasIdentifiers() {
        return this.identifiers != null && !this.identifiers.isEmpty();
    }

    @Override
    public int numIdentifiers() {
        return this.identifiers != null ? this.identifiers.size() : 0;
    }

    @Override
    public Identifier getIdentifier(int index) {
        return this.identifiers.get(index);
    }

    @Override
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public void addIdentifier(Identifier identifier) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifier);
    }

    @Override
    public void addIdentifiers(List<Identifier> identifiers) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.addAll(identifiers);
    }

    public boolean equalsName(Unit unit) {
        return this.name.equalsIgnoreCase(unit.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conversionFactor == null ? 0 : this.conversionFactor.hashCode());
        result = 31 * result + (this.identifiers == null ? 0 : this.identifiers.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Unit other = (Unit)obj;
        if (this.conversionFactor == null ? other.conversionFactor != null : !this.conversionFactor.equals(other.conversionFactor)) {
            return false;
        }
        if (this.identifiers == null ? other.identifiers != null : !this.identifiers.equals(other.identifiers)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String value = null;
        try (CRSWriter writer = new CRSWriter();){
            writer.write(this);
            value = writer.toString();
        }
        return value;
    }
}

