/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper;

import java.util.Iterator;
import java.util.Objects;
import java.util.OptionalInt;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.wrapper.AbstractGeometry;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.apache.sis.geometry.wrapper.SpatialOperationContext;
import org.apache.sis.pending.geoapi.filter.DistanceOperatorName;
import org.apache.sis.pending.geoapi.filter.SpatialOperatorName;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.util.Classes;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class GeometryWrapper
extends AbstractGeometry
implements Geometry {
    protected GeometryWrapper() {
    }

    protected abstract Geometries<?> factory();

    protected abstract Object implementation();

    public OptionalInt getSRID() {
        return OptionalInt.empty();
    }

    public abstract CoordinateReferenceSystem getCoordinateReferenceSystem();

    public abstract void setCoordinateReferenceSystem(CoordinateReferenceSystem var1);

    public abstract GeneralEnvelope getEnvelope();

    public abstract DirectPosition getCentroid();

    public abstract double[] getPointCoordinates();

    public abstract double[] getAllCoordinates();

    public abstract Object mergePolylines(Iterator<?> var1);

    public final boolean predicate(DistanceOperatorName type, GeometryWrapper other, Quantity<Length> distance, SpatialOperationContext context) {
        GeometryWrapper[] geometries = new GeometryWrapper[]{this, other};
        try {
            if (context.transform(geometries)) {
                double dv = distance.getValue().doubleValue();
                Unit unit = ReferencingUtilities.getUnit((CoordinateReferenceSystem)context.commonCRS);
                if (unit != null) {
                    dv = distance.getUnit().getConverterToAny(unit).convert(dv);
                }
                return geometries[0].predicateSameCRS(type, geometries[1], dv);
            }
        }
        catch (IncommensurableException | TransformException | FactoryException e) {
            throw new IllegalArgumentException(e);
        }
        return SpatialOperationContext.negativeResult(type);
    }

    public final boolean predicate(SpatialOperatorName type, GeometryWrapper other, SpatialOperationContext context) {
        GeometryWrapper[] geometries = new GeometryWrapper[]{this, other};
        try {
            if (context.transform(geometries)) {
                return geometries[0].predicateSameCRS(type, geometries[1]);
            }
        }
        catch (IncommensurableException | TransformException | FactoryException e) {
            throw new IllegalArgumentException(e);
        }
        return SpatialOperationContext.negativeResult(type);
    }

    public final Object operation(SQLMM operation) {
        assert (operation.geometryCount() == 1 && operation.maxParamCount == 1) : operation;
        Object result = this.operationSameCRS(operation, null, null);
        assert (this.isInstance(operation, result)) : result;
        return result;
    }

    public final Object operation(SQLMM operation, GeometryWrapper other) throws TransformException {
        assert (operation.geometryCount() == 2 && operation.maxParamCount == 2) : operation;
        Object result = this.operationSameCRS(operation, this.toSameCRS(other), null);
        assert (this.isInstance(operation, result)) : result;
        return result;
    }

    public final Object operationWithArgument(SQLMM operation, Object argument) {
        assert (operation.geometryCount() == 1 && operation.maxParamCount == 2) : operation;
        if (argument == null && operation.minParamCount > 1) {
            throw new NullArgumentException(Errors.format((short)113, (Object)"arg1"));
        }
        Object result = this.operationSameCRS(operation, null, argument);
        assert (this.isInstance(operation, result)) : result;
        return result;
    }

    public final Object operationWithArgument(SQLMM operation, GeometryWrapper other, Object argument) throws TransformException {
        assert (operation.geometryCount() == 2 && operation.maxParamCount == 3) : operation;
        if (argument == null && operation.minParamCount > 2) {
            throw new NullArgumentException(Errors.format((short)113, (Object)"arg2"));
        }
        Object result = this.operationSameCRS(operation, this.toSameCRS(other), argument);
        assert (this.isInstance(operation, result)) : result;
        return result;
    }

    private GeometryWrapper toSameCRS(GeometryWrapper other) throws TransformException {
        if (this.isSameCRS(other)) {
            return other;
        }
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        return crs != null ? other.transform(crs) : this;
    }

    private boolean isInstance(SQLMM operation, Object result) {
        return result == null || operation.getReturnType(this.factory()).isInstance(result);
    }

    protected boolean predicateSameCRS(SpatialOperatorName type, GeometryWrapper other) {
        throw new UnsupportedOperationException(Geometries.unsupported(type.name()));
    }

    protected boolean predicateSameCRS(DistanceOperatorName type, GeometryWrapper other, double distance) {
        throw new UnsupportedOperationException(Geometries.unsupported(type.name()));
    }

    protected Object operationSameCRS(SQLMM operation, GeometryWrapper other, Object argument) {
        throw new UnsupportedOperationException(Geometries.unsupported(operation.name()));
    }

    public GeometryWrapper toGeometryType(GeometryType target) {
        Object geometry;
        Class<?> type = this.factory().getGeometryClass(target);
        if (type.isInstance(geometry = this.implementation())) {
            return this;
        }
        throw new UnconvertibleObjectException(Errors.format((short)7, geometry.getClass(), type));
    }

    public GeometryWrapper transform(CoordinateOperation operation, boolean validate) throws FactoryException, TransformException {
        throw new UnsupportedOperationException(Geometries.unsupported("transform"));
    }

    public GeometryWrapper transform(CoordinateReferenceSystem targetCRS) throws TransformException {
        if (targetCRS == null) {
            return this;
        }
        throw new UnsupportedOperationException(Geometries.unsupported("transform"));
    }

    public abstract boolean isSameCRS(GeometryWrapper var1);

    public abstract String formatWKT(double var1);

    public final boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass()) && Objects.equals(((GeometryWrapper)obj).implementation(), this.implementation());
    }

    public final int hashCode() {
        return ~Objects.hashCode(this.implementation());
    }

    public final String toString() {
        Class<?> c = this.implementation().getClass();
        Class<?> e = c.getEnclosingClass();
        Object s = Classes.getShortName(e != null ? e : c);
        GeneralEnvelope envelope = this.getEnvelope();
        if (envelope != null) {
            String bbox = envelope.toString();
            s = (String)s + bbox.substring(bbox.indexOf(40));
        }
        return s;
    }
}

