/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.util.Collection;
import java.util.Locale;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.base.StoreMetadata;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.distribution.Format;
import org.opengis.util.InternationalString;

public enum Capability {
    READ(166),
    WRITE(226),
    CREATE(40);

    private final short resourceKey;

    private Capability(short key) {
        this.resourceKey = key;
    }

    public static String[] providers(Locale locale, Vocabulary resources) {
        Collection<DataStoreProvider> providers = DataStores.providers();
        int count = providers.size();
        String[] list = new String[count * 2];
        int i = 0;
        for (DataStoreProvider provider : providers) {
            String complement;
            String title;
            StoreMetadata metadata = provider.getClass().getAnnotation(StoreMetadata.class);
            String capabilities = null;
            if (metadata != null) {
                for (Capability c : metadata.capabilities()) {
                    String e = resources.getString(c.resourceKey);
                    capabilities = capabilities == null ? e : resources.getString((short)181, (Object)capabilities, (Object)e.toLowerCase(locale));
                }
            }
            if (capabilities == null) {
                capabilities = resources.getString((short)207);
            }
            Format format = provider.getFormat();
            try {
                title = Types.toString((InternationalString)format.getSpecification(), (Locale)locale);
                if (title == null) {
                    title = Types.toString((InternationalString)format.getName(), (Locale)locale);
                }
                complement = provider.getShortName();
            }
            catch (BackingStoreException e) {
                title = provider.getShortName();
                complement = Exceptions.getLocalizedMessage((Throwable)Exceptions.unwrap((Exception)((Object)e)), (Locale)locale);
            }
            if (complement != null && !complement.equals(title)) {
                title = resources.getString((short)158, (Object)title, (Object)complement);
            }
            list[i++] = capabilities;
            list[i++] = title;
        }
        return list;
    }
}

