/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.dgiwg;

import mil.nga.geopackage.GeoPackageException;

public class UTMZone {
    public static final long NORTH_MIN = 32601L;
    public static final long NORTH_MAX = 32660L;
    public static final long SOUTH_MIN = 32701L;
    public static final long SOUTH_MAX = 32760L;

    public static long getZone(long epsg) {
        if (!UTMZone.isZone(epsg)) {
            UTMZone.invalidUTMZone(epsg);
        }
        return epsg % 100L;
    }

    public static String getLatDirection(long epsg) {
        String direction = null;
        if (epsg >= 32601L && epsg <= 32660L) {
            direction = "N";
        } else if (epsg >= 32701L && epsg <= 32760L) {
            direction = "S";
        } else {
            UTMZone.invalidUTMZone(epsg);
        }
        return direction;
    }

    public static long getCentralMeridian(long zone) {
        if (zone < 1L || zone > 60L) {
            throw new GeoPackageException("Invalid UTM Zone: " + zone + ", Expected 1 - 60");
        }
        return -177L + (zone - 1L) * 6L;
    }

    public static long getFalseNorthing(long epsg) {
        long falseNorthing = 0L;
        if (epsg >= 32601L && epsg <= 32660L) {
            falseNorthing = 0L;
        } else if (epsg >= 32701L && epsg <= 32760L) {
            falseNorthing = 10000000L;
        } else {
            UTMZone.invalidUTMZone(epsg);
        }
        return falseNorthing;
    }

    public static boolean isZone(long epsg) {
        return UTMZone.isNorth(epsg) || UTMZone.isSouth(epsg);
    }

    public static boolean isNorth(long epsg) {
        return epsg >= 32601L && epsg <= 32660L;
    }

    public static boolean isSouth(long epsg) {
        return epsg >= 32701L && epsg <= 32760L;
    }

    private static void invalidUTMZone(long epsg) {
        throw new GeoPackageException("Invalid UTM Zone EPSG: " + epsg + ", Expected 32601 - 32660 or 32701 - 32760");
    }
}

