/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.JSContext;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ScriptOrModule {
    protected final JSContext context;
    protected final Source source;
    private volatile Map<TruffleString, Source> importSourceCache;
    private static final VarHandle IMPORT_SOURCE_CACHE_HANDLE;

    public ScriptOrModule(JSContext context, Source source) {
        this.context = context;
        this.source = source;
    }

    public final JSContext getContext() {
        return this.context;
    }

    public final Source getSource() {
        return this.source;
    }

    public void rememberImportedModuleSource(TruffleString moduleSpecifier, Source moduleSource) {
        this.getImportSourceCache().put(moduleSpecifier, moduleSource);
    }

    private Map<TruffleString, Source> getImportSourceCache() {
        Map<TruffleString, Source> cache = this.importSourceCache;
        if (cache == null && !IMPORT_SOURCE_CACHE_HANDLE.compareAndSet(this, null, cache = new ConcurrentHashMap<TruffleString, Source>())) {
            cache = this.importSourceCache;
        }
        return cache;
    }

    static {
        try {
            IMPORT_SOURCE_CACHE_HANDLE = MethodHandles.lookup().findVarHandle(ScriptOrModule.class, "importSourceCache", Map.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }
}

