/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore;

import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileEntry;
import org.apache.baremaps.tilestore.TileStoreException;

public interface TileStore<T>
extends AutoCloseable {
    public T read(TileCoord var1) throws TileStoreException;

    default public List<T> read(List<TileCoord> tileCoords) throws TileStoreException {
        ArrayList<T> blobs = new ArrayList<T>();
        for (TileCoord tileCoord : tileCoords) {
            blobs.add(this.read(tileCoord));
        }
        return blobs;
    }

    public void write(TileCoord var1, T var2) throws TileStoreException;

    default public void write(List<TileEntry<T>> entries) throws TileStoreException {
        for (TileEntry<T> entry : entries) {
            this.write(entry.getTileCoord(), entry.getTileValue());
        }
    }

    public void delete(TileCoord var1) throws TileStoreException;

    default public void delete(List<TileCoord> tileCoords) throws TileStoreException {
        for (TileCoord tileCoord : tileCoords) {
            this.delete(tileCoord);
        }
    }
}

