/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.pmtiles;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.baremaps.maplibre.tileset.Tileset;
import org.apache.baremaps.pmtiles.PMTilesWriter;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;

public class PMTilesStore
implements TileStore<ByteBuffer> {
    private final PMTilesWriter writer;

    public PMTilesStore(Path path, Tileset tileset) throws TileStoreException {
        try {
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("name", tileset.getName());
            metadata.put("type", "baselayer");
            metadata.put("version", tileset.getVersion());
            metadata.put("description", tileset.getDescription());
            metadata.put("attribution", tileset.getAttribution());
            metadata.put("vector_layers", tileset.getVectorLayers());
            Integer minZoom = Optional.ofNullable(tileset.getMinzoom()).orElse(0);
            Integer maxZoom = Optional.ofNullable(tileset.getMaxzoom()).orElse(14);
            List<Double> bounds = Optional.ofNullable(tileset.getBounds()).orElse(List.of(Double.valueOf(-180.0), Double.valueOf(-90.0), Double.valueOf(180.0), Double.valueOf(90.0)));
            List<Double> center = Optional.ofNullable(tileset.getCenter()).orElse(List.of(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(3.0)));
            this.writer = new PMTilesWriter(path);
            this.writer.setMetadata(metadata);
            this.writer.setMinZoom(minZoom.intValue());
            this.writer.setMaxZoom(maxZoom.intValue());
            this.writer.setMinLon(bounds.get(0).doubleValue());
            this.writer.setMinLat(bounds.get(1).doubleValue());
            this.writer.setMaxLon(bounds.get(2).doubleValue());
            this.writer.setMaxLat(bounds.get(3).doubleValue());
            this.writer.setCenterLon(center.get(0).doubleValue());
            this.writer.setCenterLat(center.get(1).doubleValue());
            this.writer.setMinZoom(tileset.getMinzoom().intValue());
            this.writer.setMaxZoom(tileset.getMaxzoom().intValue());
        }
        catch (IOException e) {
            throw new TileStoreException(e);
        }
    }

    @Override
    public ByteBuffer read(TileCoord tileCoord) throws TileStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(TileCoord tileCoord, ByteBuffer blob) throws TileStoreException {
        try {
            this.writer.setTile(tileCoord.z(), tileCoord.x(), tileCoord.y(), blob.array());
        }
        catch (IOException e) {
            throw new TileStoreException(e);
        }
    }

    @Override
    public void delete(TileCoord tileCoord) throws TileStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws TileStoreException {
        try {
            this.writer.write();
        }
        catch (IOException e) {
            throw new TileStoreException(e);
        }
    }
}

