/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import springfox.documentation.common.Compatibility;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ScalarTypes;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.readers.operation.ParameterAggregator;
import springfox.documentation.spring.web.readers.parameter.ExpansionContext;
import springfox.documentation.spring.web.readers.parameter.ModelAttributeParameterExpander;

@Component
@Order(value=-2147483648)
public class OperationParameterReader
implements OperationBuilderPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationParameterReader.class);
    private final ModelAttributeParameterExpander expander;
    private final EnumTypeDeterminer enumTypeDeterminer;
    private final ParameterAggregator aggregator;
    @Autowired
    private DocumentationPluginsManager pluginsManager;

    @Autowired
    public OperationParameterReader(ModelAttributeParameterExpander expander, EnumTypeDeterminer enumTypeDeterminer, ParameterAggregator aggregator) {
        this.expander = expander;
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.aggregator = aggregator;
    }

    public void apply(OperationContext context) {
        context.operationBuilder().parameters(context.getGlobalOperationParameters());
        List<Compatibility<Parameter, RequestParameter>> compatibilities = this.readParameters(context);
        context.operationBuilder().parameters(compatibilities.stream().map(Compatibility::getLegacy).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        context.operationBuilder().requestParameters(new HashSet(context.getGlobalRequestParameters()));
        Collection requestParameters = compatibilities.stream().map(Compatibility::getModern).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        context.operationBuilder().requestParameters(this.aggregator.aggregate(requestParameters));
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private List<Compatibility<Parameter, RequestParameter>> readParameters(OperationContext context) {
        List methodParameters = context.getParameters();
        ArrayList<Compatibility<Parameter, RequestParameter>> parameters = new ArrayList<Compatibility<Parameter, RequestParameter>>();
        LOGGER.debug("Reading parameters for method {} at path {}", (Object)context.getName(), (Object)context.requestMappingPattern());
        int index = 0;
        for (ResolvedMethodParameter methodParameter : methodParameters) {
            LOGGER.debug("Processing parameter {}", (Object)methodParameter.defaultName().orElse("<unknown>"));
            ResolvedType alternate = context.alternateFor(methodParameter.getParameterType());
            if (this.shouldIgnore(methodParameter, alternate, context.getIgnorableParameterTypes())) continue;
            ParameterContext parameterContext = new ParameterContext(methodParameter, context.getDocumentationContext(), context.getGenericsNamingStrategy(), context, index++);
            if (this.shouldExpand(methodParameter, alternate)) {
                parameters.addAll(this.expander.expand(new ExpansionContext("", alternate, context)));
                continue;
            }
            parameters.add(this.pluginsManager.parameter(parameterContext));
        }
        return parameters.stream().filter(this.hiddenParameter().negate()).collect(Collectors.toList());
    }

    private Predicate<Compatibility<Parameter, RequestParameter>> hiddenParameter() {
        return c -> c.getLegacy().map(Parameter::isHidden).orElse(false);
    }

    private boolean shouldIgnore(ResolvedMethodParameter parameter, ResolvedType resolvedParameterType, Set<Class> ignorableParamTypes) {
        if (ignorableParamTypes.contains(resolvedParameterType.getErasedType())) {
            return true;
        }
        return ignorableParamTypes.stream().filter(Annotation.class::isAssignableFrom).anyMatch(arg_0 -> ((ResolvedMethodParameter)parameter).hasParameterAnnotation(arg_0));
    }

    private boolean shouldExpand(ResolvedMethodParameter parameter, ResolvedType resolvedParamType) {
        return !parameter.hasParameterAnnotation(RequestBody.class) && !parameter.hasParameterAnnotation(RequestPart.class) && !parameter.hasParameterAnnotation(RequestParam.class) && !parameter.hasParameterAnnotation(PathVariable.class) && !ScalarTypes.builtInScalarType((Type)resolvedParamType.getErasedType()).isPresent() && !this.enumTypeDeterminer.isEnum(resolvedParamType.getErasedType()) && !Collections.isContainerType((ResolvedType)resolvedParamType) && !Maps.isMapType((ResolvedType)resolvedParamType);
    }
}

