/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.ipc.HttpTransceiver;
import org.apache.avro.ipc.Responder;

public class ResponderServlet
extends HttpServlet {
    private Responder responder;

    public ResponderServlet(Responder responder) throws IOException {
        this.responder = responder;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("avro/binary");
        List<ByteBuffer> requestBufs = HttpTransceiver.readBuffers((InputStream)request.getInputStream());
        try {
            List<ByteBuffer> responseBufs = this.responder.respond(requestBufs);
            response.setContentLength(HttpTransceiver.getLength(responseBufs));
            HttpTransceiver.writeBuffers(responseBufs, (OutputStream)response.getOutputStream());
        }
        catch (AvroRuntimeException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

