/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.example;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.inlong.tubemq.client.common.ConfirmResult;
import org.apache.inlong.tubemq.client.common.ConsumeResult;
import org.apache.inlong.tubemq.client.common.QueryMetaResult;
import org.apache.inlong.tubemq.client.config.ConsumerConfig;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.consumer.ClientBalanceConsumer;
import org.apache.inlong.tubemq.client.consumer.ConsumePosition;
import org.apache.inlong.tubemq.client.factory.MessageSessionFactory;
import org.apache.inlong.tubemq.client.factory.TubeSingleSessionFactory;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.example.MsgSendReceiveStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientBalanceConsumerExample {
    private static final Logger logger = LoggerFactory.getLogger(ClientBalanceConsumerExample.class);
    private static final MsgSendReceiveStats msgRcvStats = new MsgSendReceiveStats(false);
    private static ClientBalanceConsumer consumer;
    private static MessageSessionFactory messageSessionFactory;
    private static final ConcurrentHashMap<String, Long> partitionOffsetMap;

    public static void main(String[] args) throws Throwable {
        String masterServers = args[0];
        String topics = args[1];
        String group = args[2];
        final int msgCount = Integer.parseInt(args[3]);
        int totalGroupNodeCnt = args.length > 4 ? Integer.parseInt(args[4]) : 1;
        int nodeIndexId = args.length > 5 ? Integer.parseInt(args[5]) : 0;
        ConsumerConfig consumerConfig = new ConsumerConfig(masterServers, group);
        consumerConfig.setConsumePosition(ConsumePosition.CONSUMER_FROM_LATEST_OFFSET);
        messageSessionFactory = new TubeSingleSessionFactory((TubeClientConfig)consumerConfig);
        consumer = messageSessionFactory.createBalanceConsumer(consumerConfig);
        Map topicAndFiltersMap = MixedUtils.parseTopicParam((String)topics);
        final long metaInfoFetchInterval = consumer.getConsumerConfig().getPartMetaInfoCheckPeriodMs();
        ProcessResult procResult = new ProcessResult();
        if (!consumer.start(topicAndFiltersMap, totalGroupNodeCnt, nodeIndexId, procResult)) {
            logger.info("Initial balance consumer failure, errcode is {}, errMsg is {}", (Object)procResult.getErrCode(), (Object)procResult.getErrMsg());
            return;
        }
        Thread metaInfoUpdater = new Thread(new Runnable(){

            @Override
            public void run() {
                QueryMetaResult qryResult = new QueryMetaResult();
                ProcessResult procResult = new ProcessResult();
                block2: while (true) {
                    try {
                        while (true) {
                            if (consumer.isShutdown()) {
                                logger.info("Consumer is shutdown!");
                                break block2;
                            }
                            if (!consumer.getPartitionMetaInfo(qryResult)) {
                                if (qryResult.getErrCode() == 420) {
                                    logger.info("Consumer is shutdown!");
                                    break block2;
                                }
                            } else {
                                Map partMetaInfoMap = qryResult.getPartStatusMap();
                                if (partMetaInfoMap != null && !partMetaInfoMap.isEmpty()) {
                                    Set configuredTopicPartitions = partMetaInfoMap.keySet();
                                    Set assignedPartitions = configuredTopicPartitions.stream().filter(p -> ((long)p.hashCode() & 0xFFFFFFFFL) % (long)consumer.getSourceCount() == (long)consumer.getNodeId()).collect(Collectors.toCollection(TreeSet::new));
                                    TreeSet<String> rsvRegisteredPartSet = new TreeSet<String>();
                                    Set curRegisteredPartSet = consumer.getCurRegisteredPartSet();
                                    for (String partKey : curRegisteredPartSet) {
                                        if (!assignedPartitions.contains(partKey) || partMetaInfoMap.get(partKey) == Boolean.FALSE) {
                                            if (!consumer.disconnectFromPartition(partKey, procResult) && procResult.getErrCode() == 420) {
                                                logger.info("Consumer is shutdown!");
                                                break;
                                            }
                                            logger.info("Unregister " + partKey + ", process result is " + procResult.isSuccess() + ", err info is " + procResult.getErrMsg());
                                            continue;
                                        }
                                        rsvRegisteredPartSet.add(partKey);
                                    }
                                    for (String partKey : assignedPartitions) {
                                        if (rsvRegisteredPartSet.contains(partKey) || partMetaInfoMap.get(partKey) != Boolean.TRUE) continue;
                                        Long boostrapOffset = (Long)partitionOffsetMap.get(partKey);
                                        if (!consumer.connect2Partition(partKey, boostrapOffset == null ? -1L : boostrapOffset, procResult) && procResult.getErrCode() == 420) {
                                            logger.info("Consumer is shutdown!");
                                            break;
                                        }
                                        logger.info("Register " + partKey + ", process result is " + procResult.isSuccess() + ", err info is " + procResult.getErrMsg());
                                    }
                                }
                            }
                            ThreadUtils.sleep((long)metaInfoFetchInterval);
                        }
                    }
                    catch (Throwable e) {
                        logger.error("Consume messages failed!", e);
                        continue;
                    }
                    break;
                }
                logger.info("Consumer existed client balance thread!");
            }
        }, "partition_assigner");
        Thread[] fetchRunners = new Thread[3];
        for (int i = 0; i < fetchRunners.length; ++i) {
            fetchRunners[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        int getCount = msgCount;
                        ConsumeResult csmResult = new ConsumeResult();
                        ConfirmResult cfmResult = new ConfirmResult();
                        while (!consumer.isPartitionsReady(5000L) && !consumer.isShutdown()) {
                        }
                        do {
                            if (consumer.isShutdown()) {
                                logger.info("Consumer is shutdown!");
                                break;
                            }
                            if (consumer.getMessage(csmResult)) {
                                List messageList = csmResult.getMessageList();
                                if (messageList != null && !messageList.isEmpty()) {
                                    msgRcvStats.addMsgCount(csmResult.getTopicName(), messageList.size());
                                }
                                partitionOffsetMap.put(csmResult.getPartitionKey(), csmResult.getCurrOffset());
                                if (!consumer.confirmConsume(csmResult.getConfirmContext(), true, cfmResult)) continue;
                                partitionOffsetMap.put(cfmResult.getPartitionKey(), cfmResult.getCurrOffset());
                                continue;
                            }
                            if (csmResult.getErrCode() != 420) continue;
                            logger.info("Found that the client has shutdown, exit!");
                        } while (msgCount <= 0 || --getCount > 0);
                    }
                    catch (Throwable e) {
                        logger.error("Consume messages failed!", e);
                    }
                    msgRcvStats.stopStats();
                    logger.info("Fetch runner exit!");
                }
            }, "_fetch_runner_" + i);
        }
        metaInfoUpdater.start();
        for (Thread thread : fetchRunners) {
            thread.start();
        }
        Thread statisticThread = new Thread((Runnable)msgRcvStats, "Receive Statistic Thread");
        statisticThread.start();
    }

    static {
        partitionOffsetMap = new ConcurrentHashMap();
    }
}

