/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.csv.CsvCommons;
import org.apache.flink.formats.csv.CsvFormatOptions;
import org.apache.flink.formats.csv.CsvRowDataDeserializationSchema;
import org.apache.flink.formats.csv.CsvRowDataSerializationSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public final class CsvFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, final ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        CsvCommons.validateFormatOptions(formatOptions);
        return new DecodingFormat<DeserializationSchema<RowData>>(){

            public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType) {
                RowType rowType = (RowType)producedDataType.getLogicalType();
                TypeInformation rowDataTypeInfo = context.createTypeInformation(producedDataType);
                CsvRowDataDeserializationSchema.Builder schemaBuilder = new CsvRowDataDeserializationSchema.Builder(rowType, (TypeInformation<RowData>)rowDataTypeInfo);
                CsvFormatFactory.configureDeserializationSchema(formatOptions, schemaBuilder);
                return schemaBuilder.build();
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, final ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        CsvCommons.validateFormatOptions(formatOptions);
        return new EncodingFormat<SerializationSchema<RowData>>(){

            public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
                RowType rowType = (RowType)consumedDataType.getLogicalType();
                CsvRowDataSerializationSchema.Builder schemaBuilder = new CsvRowDataSerializationSchema.Builder(rowType);
                CsvFormatFactory.configureSerializationSchema(formatOptions, schemaBuilder);
                return schemaBuilder.build();
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    public String factoryIdentifier() {
        return "csv";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return CsvCommons.optionalOptions();
    }

    public Set<ConfigOption<?>> forwardOptions() {
        return CsvCommons.forwardOptions();
    }

    private static void configureDeserializationSchema(ReadableConfig formatOptions, CsvRowDataDeserializationSchema.Builder schemaBuilder) {
        formatOptions.getOptional(CsvFormatOptions.FIELD_DELIMITER).map(delimiter -> Character.valueOf(StringEscapeUtils.unescapeJava(delimiter).charAt(0))).ifPresent(schemaBuilder::setFieldDelimiter);
        if (((Boolean)formatOptions.get(CsvFormatOptions.DISABLE_QUOTE_CHARACTER)).booleanValue()) {
            schemaBuilder.disableQuoteCharacter();
        } else {
            formatOptions.getOptional(CsvFormatOptions.QUOTE_CHARACTER).map(quote -> Character.valueOf(quote.charAt(0))).ifPresent(schemaBuilder::setQuoteCharacter);
        }
        formatOptions.getOptional(CsvFormatOptions.ALLOW_COMMENTS).ifPresent(schemaBuilder::setAllowComments);
        formatOptions.getOptional(CsvFormatOptions.IGNORE_PARSE_ERRORS).ifPresent(schemaBuilder::setIgnoreParseErrors);
        formatOptions.getOptional(CsvFormatOptions.ARRAY_ELEMENT_DELIMITER).ifPresent(schemaBuilder::setArrayElementDelimiter);
        formatOptions.getOptional(CsvFormatOptions.ESCAPE_CHARACTER).map(escape -> Character.valueOf(escape.charAt(0))).ifPresent(schemaBuilder::setEscapeCharacter);
        formatOptions.getOptional(CsvFormatOptions.NULL_LITERAL).ifPresent(schemaBuilder::setNullLiteral);
    }

    private static void configureSerializationSchema(ReadableConfig formatOptions, CsvRowDataSerializationSchema.Builder schemaBuilder) {
        formatOptions.getOptional(CsvFormatOptions.FIELD_DELIMITER).map(delimiter -> Character.valueOf(StringEscapeUtils.unescapeJava(delimiter).charAt(0))).ifPresent(schemaBuilder::setFieldDelimiter);
        if (((Boolean)formatOptions.get(CsvFormatOptions.DISABLE_QUOTE_CHARACTER)).booleanValue()) {
            schemaBuilder.disableQuoteCharacter();
        } else {
            formatOptions.getOptional(CsvFormatOptions.QUOTE_CHARACTER).map(quote -> Character.valueOf(quote.charAt(0))).ifPresent(schemaBuilder::setQuoteCharacter);
        }
        formatOptions.getOptional(CsvFormatOptions.ARRAY_ELEMENT_DELIMITER).ifPresent(schemaBuilder::setArrayElementDelimiter);
        formatOptions.getOptional(CsvFormatOptions.ESCAPE_CHARACTER).map(escape -> Character.valueOf(escape.charAt(0))).ifPresent(schemaBuilder::setEscapeCharacter);
        formatOptions.getOptional(CsvFormatOptions.NULL_LITERAL).ifPresent(schemaBuilder::setNullLiteral);
    }
}

