/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.loader;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.audit.loader.SocketAddressListLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsSocketAddressListLoader
implements SocketAddressListLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DnsSocketAddressListLoader.class);
    public static final String KEY_DNS_ADDRESS = "audit.dns.address";
    public static final String KEY_DNS_PORT = "audit.dns.port";
    private Map<String, String> commonProperties;

    @Override
    public void setCommonProperties(Map<String, String> commonProperties) {
        this.commonProperties = commonProperties;
    }

    @Override
    public List<String> loadSocketAddressList() {
        if (this.commonProperties == null) {
            return null;
        }
        ArrayList<String> ipPortList = new ArrayList<String>();
        String dns = this.commonProperties.get(KEY_DNS_ADDRESS);
        String dnsPort = this.commonProperties.get(KEY_DNS_PORT);
        if (!StringUtils.isEmpty(dns) && !StringUtils.isEmpty(dnsPort)) {
            try {
                InetAddress[] addrs;
                for (InetAddress addr : addrs = InetAddress.getAllByName(dns)) {
                    ipPortList.add(addr.getHostAddress() + ":" + dnsPort);
                }
            }
            catch (Throwable t2) {
                LOG.error(t2.getMessage(), t2);
            }
        }
        Collections.sort(ipPortList);
        return ipPortList;
    }

    public static void main(String[] args) {
        try {
            InetAddress[] addrs = InetAddress.getAllByName("inlong.woa.com");
            System.out.println(addrs);
        }
        catch (Throwable t2) {
            LOG.error(t2.getMessage(), t2);
        }
    }
}

