/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.base;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.ArrayFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.ArrayTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.BasicFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.BinaryFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.BinaryTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.BooleanFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.BooleanTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.ByteFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.ByteTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.DateFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.DateTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.DecimalFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.DecimalTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.DoubleFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.DoubleTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FloatFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FloatTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatUtils;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.IntFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.IntTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.LocalZonedTimestampFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.LocalZonedTimestampTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.LongFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.LongTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.MapFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.MapTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.NullFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.ShortFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.ShortTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.StringFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.StringTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.TimeFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.TimeTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.TimestampFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.TimestampTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.TypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.VarBinaryFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.VarCharFormatInfo;
import org.apache.inlong.sort.formats.inlongmsg.FailureHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableFormatUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TableFormatUtils.class);
    private static final String SCHEMA = "schema";
    private static final String SCHEMA_PROCTIME = "proctime";
    private static final String SCHEMA_FROM = "from";
    private static final String ROWTIME_TIMESTAMPS_TYPE = "rowtime.timestamps.type";
    private static final String ROWTIME_TIMESTAMPS_TYPE_VALUE_FROM_FIELD = "from-field";
    private static final String ROWTIME_TIMESTAMPS_FROM = "rowtime.timestamps.from";

    public static FormatInfo deriveFormatInfo(LogicalType logicalType) {
        if (logicalType instanceof VarCharType) {
            return StringFormatInfo.INSTANCE;
        }
        if (logicalType instanceof BooleanType) {
            return BooleanFormatInfo.INSTANCE;
        }
        if (logicalType instanceof TinyIntType) {
            return ByteFormatInfo.INSTANCE;
        }
        if (logicalType instanceof SmallIntType) {
            return ShortFormatInfo.INSTANCE;
        }
        if (logicalType instanceof IntType) {
            return IntFormatInfo.INSTANCE;
        }
        if (logicalType instanceof BigIntType) {
            return LongFormatInfo.INSTANCE;
        }
        if (logicalType instanceof FloatType) {
            return FloatFormatInfo.INSTANCE;
        }
        if (logicalType instanceof DoubleType) {
            return DoubleFormatInfo.INSTANCE;
        }
        if (logicalType instanceof DecimalType) {
            return DecimalFormatInfo.INSTANCE;
        }
        if (logicalType instanceof DateType) {
            return new DateFormatInfo();
        }
        if (logicalType instanceof TimeType) {
            return new TimeFormatInfo();
        }
        if (logicalType instanceof TimestampType) {
            return new TimestampFormatInfo();
        }
        if (logicalType instanceof LocalZonedTimestampType) {
            return new LocalZonedTimestampFormatInfo();
        }
        if (logicalType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)logicalType;
            LogicalType elementType = arrayType.getElementType();
            FormatInfo elementFormatInfo = TableFormatUtils.deriveFormatInfo(elementType);
            return new ArrayFormatInfo(elementFormatInfo);
        }
        if (logicalType instanceof MapType) {
            MapType mapType = (MapType)logicalType;
            LogicalType keyType = mapType.getKeyType();
            LogicalType valueType = mapType.getValueType();
            FormatInfo keyFormatInfo = TableFormatUtils.deriveFormatInfo(keyType);
            FormatInfo valueFormatInfo = TableFormatUtils.deriveFormatInfo(valueType);
            return new MapFormatInfo(keyFormatInfo, valueFormatInfo);
        }
        if (logicalType instanceof RowType) {
            RowType rowType = (RowType)logicalType;
            List rowFields = rowType.getFields();
            String[] fieldNames = new String[rowFields.size()];
            FormatInfo[] fieldFormatInfos = new FormatInfo[rowFields.size()];
            for (int i = 0; i < rowFields.size(); ++i) {
                RowType.RowField rowField = (RowType.RowField)rowFields.get(i);
                fieldNames[i] = rowField.getName();
                fieldFormatInfos[i] = TableFormatUtils.deriveFormatInfo(rowField.getType());
            }
            return new RowFormatInfo(fieldNames, fieldFormatInfos);
        }
        if (logicalType instanceof BinaryType) {
            return BinaryFormatInfo.INSTANCE;
        }
        if (logicalType instanceof VarBinaryType) {
            return VarBinaryFormatInfo.INSTANCE;
        }
        if (logicalType instanceof NullType) {
            return NullFormatInfo.INSTANCE;
        }
        throw new IllegalArgumentException(String.format("not found logicalType %s", logicalType == null ? "null" : logicalType.toString()));
    }

    public static LogicalType deriveLogicalType(FormatInfo formatInfo) {
        if (formatInfo instanceof StringFormatInfo) {
            return new VarCharType(Integer.MAX_VALUE);
        }
        if (formatInfo instanceof VarCharFormatInfo) {
            return new VarCharType(((VarCharFormatInfo)formatInfo).getLength());
        }
        if (formatInfo instanceof BooleanFormatInfo) {
            return new BooleanType();
        }
        if (formatInfo instanceof ByteFormatInfo) {
            return new TinyIntType();
        }
        if (formatInfo instanceof ShortFormatInfo) {
            return new SmallIntType();
        }
        if (formatInfo instanceof IntFormatInfo) {
            return new IntType();
        }
        if (formatInfo instanceof LongFormatInfo) {
            return new BigIntType();
        }
        if (formatInfo instanceof FloatFormatInfo) {
            return new FloatType();
        }
        if (formatInfo instanceof DoubleFormatInfo) {
            return new DoubleType();
        }
        if (formatInfo instanceof DecimalFormatInfo) {
            DecimalFormatInfo decimalFormatInfo = (DecimalFormatInfo)formatInfo;
            return new DecimalType(decimalFormatInfo.getPrecision(), decimalFormatInfo.getScale());
        }
        if (formatInfo instanceof TimeFormatInfo) {
            return new TimeType(((TimeFormatInfo)formatInfo).getPrecision());
        }
        if (formatInfo instanceof DateFormatInfo) {
            return new DateType();
        }
        if (formatInfo instanceof TimestampFormatInfo) {
            return new TimestampType(((TimestampFormatInfo)formatInfo).getPrecision());
        }
        if (formatInfo instanceof LocalZonedTimestampFormatInfo) {
            return new LocalZonedTimestampType(((LocalZonedTimestampFormatInfo)formatInfo).getPrecision());
        }
        if (formatInfo instanceof ArrayFormatInfo) {
            FormatInfo elementFormatInfo = ((ArrayFormatInfo)formatInfo).getElementFormatInfo();
            return new ArrayType(TableFormatUtils.deriveLogicalType(elementFormatInfo));
        }
        if (formatInfo instanceof MapFormatInfo) {
            MapFormatInfo mapFormatInfo = (MapFormatInfo)formatInfo;
            FormatInfo keyFormatInfo = mapFormatInfo.getKeyFormatInfo();
            FormatInfo valueFormatInfo = mapFormatInfo.getValueFormatInfo();
            return new MapType(TableFormatUtils.deriveLogicalType(keyFormatInfo), TableFormatUtils.deriveLogicalType(valueFormatInfo));
        }
        if (formatInfo instanceof RowFormatInfo) {
            RowFormatInfo rowFormatInfo = (RowFormatInfo)formatInfo;
            FormatInfo[] formatInfos = rowFormatInfo.getFieldFormatInfos();
            int formatInfosSize = formatInfos.length;
            LogicalType[] logicalTypes = new LogicalType[formatInfosSize];
            for (int i = 0; i < formatInfosSize; ++i) {
                logicalTypes[i] = TableFormatUtils.deriveLogicalType(formatInfos[i]);
            }
            return RowType.of((LogicalType[])logicalTypes, (String[])rowFormatInfo.getFieldNames());
        }
        if (formatInfo instanceof BinaryFormatInfo) {
            BinaryFormatInfo binaryFormatInfo = (BinaryFormatInfo)formatInfo;
            return new BinaryType(binaryFormatInfo.getLength());
        }
        if (formatInfo instanceof VarBinaryFormatInfo) {
            VarBinaryFormatInfo varBinaryFormatInfo = (VarBinaryFormatInfo)formatInfo;
            return new VarBinaryType(varBinaryFormatInfo.getLength());
        }
        if (formatInfo instanceof NullFormatInfo) {
            return new NullType();
        }
        throw new IllegalArgumentException(String.format("not found formatInfo %s", formatInfo == null ? "null" : formatInfo.toString()));
    }

    public static TypeInformation<?> getType(TypeInfo typeInfo) {
        if (typeInfo instanceof StringTypeInfo) {
            return Types.STRING;
        }
        if (typeInfo instanceof BooleanTypeInfo) {
            return Types.BOOLEAN;
        }
        if (typeInfo instanceof ByteTypeInfo) {
            return Types.BYTE;
        }
        if (typeInfo instanceof ShortTypeInfo) {
            return Types.SHORT;
        }
        if (typeInfo instanceof IntTypeInfo) {
            return Types.INT;
        }
        if (typeInfo instanceof LongTypeInfo) {
            return Types.LONG;
        }
        if (typeInfo instanceof FloatTypeInfo) {
            return Types.FLOAT;
        }
        if (typeInfo instanceof DoubleTypeInfo) {
            return Types.DOUBLE;
        }
        if (typeInfo instanceof DecimalTypeInfo) {
            return Types.BIG_DEC;
        }
        if (typeInfo instanceof DateTypeInfo) {
            return Types.SQL_DATE;
        }
        if (typeInfo instanceof TimeTypeInfo) {
            return Types.SQL_TIME;
        }
        if (typeInfo instanceof TimestampTypeInfo) {
            return Types.SQL_TIMESTAMP;
        }
        if (typeInfo instanceof LocalZonedTimestampTypeInfo) {
            return Types.LOCAL_DATE_TIME;
        }
        if (typeInfo instanceof BinaryTypeInfo) {
            return Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE);
        }
        if (typeInfo instanceof ArrayTypeInfo) {
            ArrayTypeInfo arrayTypeInfo = (ArrayTypeInfo)typeInfo;
            TypeInfo elementTypeInfo = arrayTypeInfo.getElementTypeInfo();
            TypeInformation<?> elementType = TableFormatUtils.getType(elementTypeInfo);
            return Types.OBJECT_ARRAY(elementType);
        }
        if (typeInfo instanceof MapTypeInfo) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            TypeInfo keyTypeInfo = mapTypeInfo.getKeyTypeInfo();
            TypeInfo valueTypeInfo = mapTypeInfo.getValueTypeInfo();
            TypeInformation<?> keyType = TableFormatUtils.getType(keyTypeInfo);
            TypeInformation<?> valueType = TableFormatUtils.getType(valueTypeInfo);
            return Types.MAP(keyType, valueType);
        }
        if (typeInfo instanceof RowTypeInfo) {
            RowTypeInfo rowTypeInfo = (RowTypeInfo)typeInfo;
            String[] fieldNames = rowTypeInfo.getFieldNames();
            TypeInfo[] fieldTypeInfos = rowTypeInfo.getFieldTypeInfos();
            TypeInformation[] fieldTypes = (TypeInformation[])Arrays.stream(fieldTypeInfos).map(TableFormatUtils::getType).toArray(TypeInformation[]::new);
            return Types.ROW_NAMED((String[])fieldNames, (TypeInformation[])fieldTypes);
        }
        throw new IllegalStateException("Unexpected type info " + typeInfo + ".");
    }

    public static DataType getDataType(TypeInfo typeInfo) {
        if (typeInfo instanceof StringTypeInfo) {
            return (DataType)DataTypes.STRING().bridgedTo(String.class);
        }
        if (typeInfo instanceof BooleanTypeInfo) {
            return (DataType)DataTypes.BOOLEAN().bridgedTo(Boolean.class);
        }
        if (typeInfo instanceof ByteTypeInfo) {
            return (DataType)DataTypes.TINYINT().bridgedTo(Byte.class);
        }
        if (typeInfo instanceof ShortTypeInfo) {
            return (DataType)DataTypes.SMALLINT().bridgedTo(Short.class);
        }
        if (typeInfo instanceof IntTypeInfo) {
            return (DataType)DataTypes.INT().bridgedTo(Integer.class);
        }
        if (typeInfo instanceof LongTypeInfo) {
            return (DataType)DataTypes.BIGINT().bridgedTo(Long.class);
        }
        if (typeInfo instanceof FloatTypeInfo) {
            return (DataType)DataTypes.FLOAT().bridgedTo(Float.class);
        }
        if (typeInfo instanceof DoubleTypeInfo) {
            return (DataType)DataTypes.DOUBLE().bridgedTo(Double.class);
        }
        if (typeInfo instanceof DecimalTypeInfo) {
            return (DataType)DataTypes.DECIMAL((int)38, (int)18).bridgedTo(BigDecimal.class);
        }
        if (typeInfo instanceof DateTypeInfo) {
            return (DataType)DataTypes.DATE().bridgedTo(Date.class);
        }
        if (typeInfo instanceof TimeTypeInfo) {
            return (DataType)DataTypes.TIME((int)0).bridgedTo(Time.class);
        }
        if (typeInfo instanceof TimestampTypeInfo) {
            return (DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(Timestamp.class);
        }
        if (typeInfo instanceof ArrayTypeInfo) {
            ArrayTypeInfo arrayTypeInfo = (ArrayTypeInfo)typeInfo;
            TypeInfo elementTypeInfo = arrayTypeInfo.getElementTypeInfo();
            DataType elementType = TableFormatUtils.getDataType(elementTypeInfo);
            Class<?> arrayClass = Array.newInstance(elementType.getConversionClass(), 0).getClass();
            return (DataType)DataTypes.ARRAY((DataType)elementType).bridgedTo(arrayClass);
        }
        if (typeInfo instanceof MapTypeInfo) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            TypeInfo keyTypeInfo = mapTypeInfo.getKeyTypeInfo();
            TypeInfo valueTypeInfo = mapTypeInfo.getValueTypeInfo();
            DataType keyType = TableFormatUtils.getDataType(keyTypeInfo);
            DataType valueType = TableFormatUtils.getDataType(valueTypeInfo);
            return (DataType)DataTypes.MAP((DataType)keyType, (DataType)valueType).bridgedTo(Map.class);
        }
        if (typeInfo instanceof RowTypeInfo) {
            RowTypeInfo rowTypeInfo = (RowTypeInfo)typeInfo;
            String[] fieldNames = rowTypeInfo.getFieldNames();
            TypeInfo[] fieldTypeInfos = rowTypeInfo.getFieldTypeInfos();
            DataTypes.Field[] fields = (DataTypes.Field[])IntStream.range(0, fieldNames.length).mapToObj(i -> {
                DataType fieldType = TableFormatUtils.getDataType(fieldTypeInfos[i]);
                return DataTypes.FIELD((String)fieldNames[i], (DataType)fieldType);
            }).toArray(DataTypes.Field[]::new);
            return (DataType)DataTypes.ROW((DataTypes.Field[])fields).bridgedTo(Row.class);
        }
        throw new IllegalStateException("Unexpected format.");
    }

    public static RowFormatInfo deserializeRowFormatInfo(DescriptorProperties descriptorProperties) {
        try {
            String schema = descriptorProperties.getString("format.schema");
            FormatInfo formatInfo = FormatUtils.demarshall(schema);
            if (!(formatInfo instanceof RowFormatInfo)) {
                throw new IllegalStateException("Unexpected format type.");
            }
            return (RowFormatInfo)formatInfo;
        }
        catch (Exception e) {
            throw new ValidationException("The schema is invalid.", (Throwable)e);
        }
    }

    public static RowFormatInfo deriveRowFormatInfo(DescriptorProperties descriptorProperties) {
        TableSchema tableSchema = TableFormatUtils.deriveSchema(descriptorProperties.asMap());
        int numFields = tableSchema.getFieldCount();
        String[] fieldNames = tableSchema.getFieldNames();
        DataType[] fieldTypes = tableSchema.getFieldDataTypes();
        FormatInfo[] fieldFormatInfos = new FormatInfo[numFields];
        for (int i = 0; i < numFields; ++i) {
            LogicalType fieldType = fieldTypes[i].getLogicalType();
            fieldFormatInfos[i] = TableFormatUtils.deriveFormatInfo(fieldType);
        }
        return new RowFormatInfo(fieldNames, fieldFormatInfos);
    }

    public static RowFormatInfo getRowFormatInfo(DescriptorProperties descriptorProperties) {
        if (descriptorProperties.containsKey("format.schema")) {
            return TableFormatUtils.deserializeRowFormatInfo(descriptorProperties);
        }
        return TableFormatUtils.deriveRowFormatInfo(descriptorProperties);
    }

    public static RowFormatInfo projectRowFormatInfo(RowFormatInfo rowFormatInfo, int[] fields) {
        String[] fieldNames = rowFormatInfo.getFieldNames();
        FormatInfo[] fieldFormatInfos = rowFormatInfo.getFieldFormatInfos();
        String[] projectedFieldNames = new String[fields.length];
        FormatInfo[] projectedFieldFormatInfos = new FormatInfo[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            projectedFieldNames[i] = fieldNames[fields[i]];
            projectedFieldFormatInfos[i] = fieldFormatInfos[fields[i]];
        }
        return new RowFormatInfo(projectedFieldNames, projectedFieldFormatInfos);
    }

    public static void validateSchema(DescriptorProperties descriptorProperties) {
        boolean defineSchema = descriptorProperties.containsKey("format.schema");
        boolean deriveSchema = descriptorProperties.containsKey("format.derive-schema");
        if (defineSchema && deriveSchema) {
            throw new ValidationException("Format cannot define a schema and derive from the table's schema at the same time.");
        }
        if (defineSchema) {
            descriptorProperties.validateString("format.schema", false);
        } else if (deriveSchema) {
            descriptorProperties.validateBoolean("format.derive-schema", false);
        } else {
            throw new ValidationException("A definition of a schema or derivation from the table's schema is required.");
        }
    }

    public static TableSchema deriveSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties();
        descriptorProperties.putProperties(properties);
        TableSchema.Builder builder = TableSchema.builder();
        TableSchema tableSchema = descriptorProperties.getTableSchema(SCHEMA);
        for (int i = 0; i < tableSchema.getFieldCount(); ++i) {
            String aliasName;
            TableColumn tableColumn = (TableColumn)tableSchema.getTableColumns().get(i);
            String fieldName = tableColumn.getName();
            DataType dataType = tableColumn.getType();
            if (!tableColumn.isPhysical()) continue;
            boolean isProctime = descriptorProperties.getOptionalBoolean("schema." + i + '.' + SCHEMA_PROCTIME).orElse(false);
            String timestampKey = "schema." + i + '.' + ROWTIME_TIMESTAMPS_TYPE;
            boolean isRowtime = descriptorProperties.containsKey(timestampKey);
            if (!isProctime && !isRowtime) {
                aliasName = descriptorProperties.getOptionalString("schema." + i + '.' + SCHEMA_FROM).orElse(fieldName);
                builder.field(aliasName, dataType);
                continue;
            }
            if (!isRowtime || !descriptorProperties.isValue(timestampKey, ROWTIME_TIMESTAMPS_TYPE_VALUE_FROM_FIELD)) continue;
            aliasName = descriptorProperties.getString("schema." + i + '.' + ROWTIME_TIMESTAMPS_FROM);
            builder.field(aliasName, dataType);
        }
        return builder.build();
    }

    public static Object deserializeBasicField(String fieldName, FormatInfo fieldFormatInfo, String fieldText, String nullLiteral, FailureHandler failureHandler) throws Exception {
        Preconditions.checkState((boolean)(fieldFormatInfo instanceof BasicFormatInfo));
        if (fieldText == null) {
            return null;
        }
        if (nullLiteral == null) {
            if (fieldText.isEmpty()) {
                if (fieldFormatInfo instanceof StringFormatInfo) {
                    return "";
                }
                return null;
            }
        } else if (fieldText.equals(nullLiteral)) {
            return null;
        }
        try {
            return ((BasicFormatInfo)fieldFormatInfo).deserialize(fieldText);
        }
        catch (Exception e) {
            LOG.warn("Could not properly deserialize the text " + fieldText + " for field " + fieldName + ".", e);
            if (failureHandler != null) {
                failureHandler.onConvertingFieldFailure(fieldName, fieldText, fieldFormatInfo, e);
            }
            return null;
        }
    }

    public static long getFormatValueLength(FormatInfo fieldFormatInfo, String fieldText) {
        if (fieldFormatInfo instanceof BooleanFormatInfo) {
            return 4L;
        }
        if (fieldFormatInfo instanceof ByteFormatInfo) {
            return 4L;
        }
        if (fieldFormatInfo instanceof BooleanFormatInfo) {
            return 4L;
        }
        if (fieldFormatInfo instanceof ShortFormatInfo) {
            return 4L;
        }
        if (fieldFormatInfo instanceof IntFormatInfo) {
            return 4L;
        }
        if (fieldFormatInfo instanceof LongFormatInfo) {
            return 8L;
        }
        if (fieldFormatInfo instanceof FloatFormatInfo) {
            return 8L;
        }
        if (fieldFormatInfo instanceof DoubleFormatInfo) {
            return 8L;
        }
        if (fieldFormatInfo instanceof DecimalFormatInfo) {
            return 8L;
        }
        if (fieldFormatInfo instanceof DateFormatInfo || fieldFormatInfo instanceof TimeFormatInfo || fieldFormatInfo instanceof TimestampFormatInfo) {
            return 8L;
        }
        if (StringUtils.isNotEmpty(fieldText)) {
            return fieldText.length();
        }
        return 0L;
    }

    public static String serializeBasicField(String fieldName, FormatInfo fieldFormatInfo, Object field, String nullLiteral) {
        Preconditions.checkState((boolean)(fieldFormatInfo instanceof BasicFormatInfo));
        if (field == null) {
            return nullLiteral == null ? "" : nullLiteral;
        }
        try {
            return ((BasicFormatInfo)fieldFormatInfo).serialize(field);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not properly serialize the value " + field + " for field " + fieldName + ".", e);
        }
    }

    public static RowFormatInfo deriveRowFormatInfo(RowType rowType) {
        List fields = rowType.getFields();
        FormatInfo[] fieldFormatInfos = new FormatInfo[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            LogicalType fieldType = ((RowType.RowField)fields.get(i)).getType();
            fieldFormatInfos[i] = TableFormatUtils.deriveFormatInfo(fieldType);
        }
        return new RowFormatInfo(rowType.getFieldNames().toArray(new String[1]), fieldFormatInfos);
    }

    public static RowFormatInfo deriveRowFormatInfo(DataType dataType) {
        RowType rowType = (RowType)dataType.getLogicalType();
        int size = rowType.getFields().size();
        FormatInfo[] fieldFormatInfos = new FormatInfo[size];
        String[] fieldNames = new String[size];
        for (int i = 0; i < size; ++i) {
            LogicalType fieldType = rowType.getTypeAt(i);
            fieldFormatInfos[i] = TableFormatUtils.deriveFormatInfo(fieldType);
            fieldNames[i] = (String)rowType.getFieldNames().get(i);
        }
        return new RowFormatInfo(fieldNames, fieldFormatInfos);
    }

    public static RowFormatInfo deserializeRowFormatInfo(String rowFormatInfoStr) {
        try {
            FormatInfo formatInfo = FormatUtils.demarshall(rowFormatInfoStr);
            if (!(formatInfo instanceof RowFormatInfo)) {
                throw new IllegalStateException("Unexpected format type.");
            }
            return (RowFormatInfo)formatInfo;
        }
        catch (Exception e) {
            throw new ValidationException("The schema is invalid.", (Throwable)e);
        }
    }

    public static void getValidateProperties(DescriptorProperties properties) {
        properties.validateString("format.type", false, 1);
        properties.validateString("format.property-version", true, 1);
        properties.validateString("format.escape-character", true, 1, 1);
    }
}

