/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.sort.protocol.MetaFieldInfo;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=FieldInfo.class, name="field"), @JsonSubTypes.Type(value=MetaFieldInfo.class, name="metaField")})
public class FieldInfo
implements FunctionParam,
Serializable {
    private static final long serialVersionUID = 5871970550803344673L;
    @JsonProperty(value="name")
    private final String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="nodeId")
    private String nodeId;
    @JsonIgnore
    private String tableNameAlias;
    @Nullable
    @JsonProperty(value="formatInfo")
    private FormatInfo formatInfo;

    public FieldInfo(@JsonProperty(value="name") String name, @JsonProperty(value="formatInfo") FormatInfo formatInfo) {
        this(name, null, formatInfo);
    }

    public FieldInfo(@JsonProperty(value="name") String name) {
        this(name, null, null);
    }

    @JsonCreator
    public FieldInfo(@JsonProperty(value="name") String name, @JsonProperty(value="nodeId") String nodeId, @Nullable @JsonProperty(value="formatInfo") FormatInfo formatInfo) {
        this.name = Preconditions.checkNotNull(name);
        this.nodeId = nodeId;
        this.formatInfo = formatInfo;
    }

    @Override
    public String format() {
        String formatName = this.name.trim();
        if (!formatName.contains(".")) {
            if (!formatName.startsWith("`")) {
                formatName = String.format("`%s", formatName);
            }
            if (!formatName.endsWith("`")) {
                formatName = String.format("%s`", formatName);
            }
        }
        if (StringUtils.isNotBlank(this.tableNameAlias)) {
            return String.format("%s.%s", this.tableNameAlias, formatName);
        }
        return formatName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getTableNameAlias() {
        return this.tableNameAlias;
    }

    @Nullable
    public FormatInfo getFormatInfo() {
        return this.formatInfo;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setTableNameAlias(String tableNameAlias) {
        this.tableNameAlias = tableNameAlias;
    }

    public void setFormatInfo(@Nullable FormatInfo formatInfo) {
        this.formatInfo = formatInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldInfo)) {
            return false;
        }
        FieldInfo other = (FieldInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$nodeId = this.getNodeId();
        String other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !this$nodeId.equals(other$nodeId)) {
            return false;
        }
        String this$tableNameAlias = this.getTableNameAlias();
        String other$tableNameAlias = other.getTableNameAlias();
        if (this$tableNameAlias == null ? other$tableNameAlias != null : !this$tableNameAlias.equals(other$tableNameAlias)) {
            return false;
        }
        FormatInfo this$formatInfo = this.getFormatInfo();
        FormatInfo other$formatInfo = other.getFormatInfo();
        return !(this$formatInfo == null ? other$formatInfo != null : !this$formatInfo.equals(other$formatInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FieldInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : $nodeId.hashCode());
        String $tableNameAlias = this.getTableNameAlias();
        result = result * 59 + ($tableNameAlias == null ? 43 : $tableNameAlias.hashCode());
        FormatInfo $formatInfo = this.getFormatInfo();
        result = result * 59 + ($formatInfo == null ? 43 : $formatInfo.hashCode());
        return result;
    }

    public String toString() {
        return "FieldInfo(name=" + this.getName() + ", nodeId=" + this.getNodeId() + ", tableNameAlias=" + this.getTableNameAlias() + ", formatInfo=" + this.getFormatInfo() + ")";
    }
}

