/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.load;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.LocalZonedTimestampFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.TimestampFormatInfo;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;

@JsonTypeName(value="hiveLoad")
public class HiveLoadNode
extends LoadNode
implements InlongMetric,
Serializable {
    private static final long serialVersionUID = -4547768154621816459L;
    private static final String trigger = "sink.partition-commit.trigger";
    private static final String timestampPattern = "partition.time-extractor.timestamp-pattern";
    private static final String delay = "sink.partition-commit.delay";
    private static final String policyKind = "sink.partition-commit.policy.kind";
    private static final String HIVE_VERSION = "3.1.3";
    @JsonProperty(value="tableName")
    @Nonnull
    private String tableName;
    @JsonProperty(value="catalogName")
    private String catalogName;
    @JsonProperty(value="database")
    @Nonnull
    private String database;
    @JsonProperty(value="hiveConfDir")
    private String hiveConfDir;
    @JsonProperty(value="hiveVersion")
    private String hiveVersion;
    @JsonProperty(value="hadoopConfDir")
    private String hadoopConfDir;
    @JsonProperty(value="partitionFields")
    private List<FieldInfo> partitionFields;

    @JsonCreator
    public HiveLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="database") String database, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="hiveConfDir") String hiveConfDir, @JsonProperty(value="hiveVersion") String hiveVersion, @JsonProperty(value="hadoopConfDir") String hadoopConfDir, @JsonProperty(value="partitionFields") List<FieldInfo> partitionFields) {
        super(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties);
        this.database = Preconditions.checkNotNull(database, "database of hive is null");
        this.tableName = Preconditions.checkNotNull(tableName, "table of hive is null");
        this.hiveConfDir = hiveConfDir;
        this.hiveVersion = null == hiveVersion ? HIVE_VERSION : hiveVersion;
        this.catalogName = catalogName;
        this.hadoopConfDir = hadoopConfDir;
        this.partitionFields = partitionFields;
        this.handleTimestampField();
    }

    private void handleTimestampField() {
        this.getFields().forEach(f -> {
            if (f.getFormatInfo() instanceof TimestampFormatInfo) {
                ((TimestampFormatInfo)f.getFormatInfo()).setPrecision(9);
            }
            if (f.getFormatInfo() instanceof LocalZonedTimestampFormatInfo) {
                ((LocalZonedTimestampFormatInfo)f.getFormatInfo()).setPrecision(9);
            }
        });
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> map = super.tableOptions();
        map.put("connector", "hive");
        map.put("default-database", this.database);
        if (null != this.hiveVersion) {
            map.put("hive-version", this.hiveVersion);
        }
        if (null != this.hadoopConfDir) {
            map.put("hadoop-conf-dir", this.hadoopConfDir);
        }
        if (null != this.hiveConfDir) {
            map.put("hive-conf-dir", this.hiveConfDir);
        }
        if (null != this.partitionFields) {
            Map<String, String> properties = super.getProperties();
            if (null == properties || !properties.containsKey(trigger)) {
                map.put(trigger, "process-time");
            }
            if (null == properties || !properties.containsKey(timestampPattern)) {
                map.put(timestampPattern, "yyyy-MM-dd");
            }
            if (null == properties || !properties.containsKey(delay)) {
                map.put(delay, "10s");
            }
            if (null == properties || !properties.containsKey(policyKind)) {
                map.put(policyKind, "metastore,success-file");
            }
        }
        return map;
    }

    @Override
    public List<FieldInfo> getPartitionFields() {
        return this.partitionFields;
    }

    @Override
    public String genTableName() {
        return this.tableName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HiveLoadNode)) {
            return false;
        }
        HiveLoadNode other = (HiveLoadNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$catalogName = this.getCatalogName();
        String other$catalogName = other.getCatalogName();
        if (this$catalogName == null ? other$catalogName != null : !this$catalogName.equals(other$catalogName)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$hiveConfDir = this.getHiveConfDir();
        String other$hiveConfDir = other.getHiveConfDir();
        if (this$hiveConfDir == null ? other$hiveConfDir != null : !this$hiveConfDir.equals(other$hiveConfDir)) {
            return false;
        }
        String this$hiveVersion = this.getHiveVersion();
        String other$hiveVersion = other.getHiveVersion();
        if (this$hiveVersion == null ? other$hiveVersion != null : !this$hiveVersion.equals(other$hiveVersion)) {
            return false;
        }
        String this$hadoopConfDir = this.getHadoopConfDir();
        String other$hadoopConfDir = other.getHadoopConfDir();
        if (this$hadoopConfDir == null ? other$hadoopConfDir != null : !this$hadoopConfDir.equals(other$hadoopConfDir)) {
            return false;
        }
        List<FieldInfo> this$partitionFields = this.getPartitionFields();
        List<FieldInfo> other$partitionFields = other.getPartitionFields();
        return !(this$partitionFields == null ? other$partitionFields != null : !((Object)this$partitionFields).equals(other$partitionFields));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HiveLoadNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $catalogName = this.getCatalogName();
        result = result * 59 + ($catalogName == null ? 43 : $catalogName.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $hiveConfDir = this.getHiveConfDir();
        result = result * 59 + ($hiveConfDir == null ? 43 : $hiveConfDir.hashCode());
        String $hiveVersion = this.getHiveVersion();
        result = result * 59 + ($hiveVersion == null ? 43 : $hiveVersion.hashCode());
        String $hadoopConfDir = this.getHadoopConfDir();
        result = result * 59 + ($hadoopConfDir == null ? 43 : $hadoopConfDir.hashCode());
        List<FieldInfo> $partitionFields = this.getPartitionFields();
        result = result * 59 + ($partitionFields == null ? 43 : ((Object)$partitionFields).hashCode());
        return result;
    }

    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    @Nonnull
    public String getDatabase() {
        return this.database;
    }

    public String getHiveConfDir() {
        return this.hiveConfDir;
    }

    public String getHiveVersion() {
        return this.hiveVersion;
    }

    public String getHadoopConfDir() {
        return this.hadoopConfDir;
    }

    public void setTableName(@Nonnull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.tableName = tableName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setDatabase(@Nonnull String database) {
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        this.database = database;
    }

    public void setHiveConfDir(String hiveConfDir) {
        this.hiveConfDir = hiveConfDir;
    }

    public void setHiveVersion(String hiveVersion) {
        this.hiveVersion = hiveVersion;
    }

    public void setHadoopConfDir(String hadoopConfDir) {
        this.hadoopConfDir = hadoopConfDir;
    }

    public void setPartitionFields(List<FieldInfo> partitionFields) {
        this.partitionFields = partitionFields;
    }

    @Override
    public String toString() {
        return "HiveLoadNode(tableName=" + this.getTableName() + ", catalogName=" + this.getCatalogName() + ", database=" + this.getDatabase() + ", hiveConfDir=" + this.getHiveConfDir() + ", hiveVersion=" + this.getHiveVersion() + ", hadoopConfDir=" + this.getHadoopConfDir() + ", partitionFields=" + this.getPartitionFields() + ")";
    }

    public HiveLoadNode() {
    }
}

