/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.load;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;

@JsonTypeName(value="kuduLoad")
public class KuduLoadNode
extends LoadNode
implements InlongMetric,
Serializable {
    private static final long serialVersionUID = -1L;
    public static final String ENABLE_CODE = "true";
    private static final String DDL_ATTR_PREFIX = "ddl.";
    private static final String EXTEND_ATTR_KEY_NAME = "keyName";
    private static final String EXTEND_ATTR_VALUE_NAME = "keyValue";
    public static final String OPTION_TABLE = "table-name";
    private static final String OPTION_MASTERS = "masters";
    @JsonProperty(value="masters")
    @Nonnull
    private String masters;
    @JsonProperty(value="tableName")
    @Nonnull
    private String tableName;
    @JsonProperty(value="partitionKey")
    private String partitionKey;

    @JsonCreator
    public KuduLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="masters") String masters, @Nonnull @JsonProperty(value="tableName") String tableName, @JsonProperty(value="partitionKey") String partitionKey) {
        super(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties);
        this.tableName = Preconditions.checkNotNull(tableName, "table name is null");
        this.masters = Preconditions.checkNotNull(masters, "masters is null");
        this.partitionKey = partitionKey;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put(OPTION_MASTERS, this.masters);
        options.put(OPTION_TABLE, this.tableName);
        Map<String, String> properties = this.getProperties();
        if (properties != null) {
            properties.forEach((keyName, ddlValue) -> {
                if (StringUtils.isNotBlank(keyName) && keyName.startsWith(DDL_ATTR_PREFIX)) {
                    String ddlKeyName = keyName.substring(DDL_ATTR_PREFIX.length());
                    options.put(ddlKeyName, (String)ddlValue);
                }
            });
        }
        options.put("connector", "kudu-inlong");
        return options;
    }

    @Override
    public String genTableName() {
        return this.tableName;
    }

    @Override
    public String getPrimaryKey() {
        return null;
    }

    @Override
    public List<FieldInfo> getPartitionFields() {
        return super.getPartitionFields();
    }

    @Nonnull
    public String getMasters() {
        return this.masters;
    }

    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setMasters(@Nonnull String masters) {
        if (masters == null) {
            throw new NullPointerException("masters is marked non-null but is null");
        }
        this.masters = masters;
    }

    public void setTableName(@Nonnull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.tableName = tableName;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    @Override
    public String toString() {
        return "KuduLoadNode(masters=" + this.getMasters() + ", tableName=" + this.getTableName() + ", partitionKey=" + this.getPartitionKey() + ")";
    }

    public KuduLoadNode() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KuduLoadNode)) {
            return false;
        }
        KuduLoadNode other = (KuduLoadNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$masters = this.getMasters();
        String other$masters = other.getMasters();
        if (this$masters == null ? other$masters != null : !this$masters.equals(other$masters)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$partitionKey = this.getPartitionKey();
        String other$partitionKey = other.getPartitionKey();
        return !(this$partitionKey == null ? other$partitionKey != null : !this$partitionKey.equals(other$partitionKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KuduLoadNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $masters = this.getMasters();
        result = result * 59 + ($masters == null ? 43 : $masters.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $partitionKey = this.getPartitionKey();
        result = result * 59 + ($partitionKey == null ? 43 : $partitionKey.hashCode());
        return result;
    }
}

