/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.load;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;

@JsonTypeName(value="postgresLoad")
public class PostgresLoadNode
extends LoadNode
implements InlongMetric,
Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="username")
    private String username;
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="tableName")
    private String tableName;
    @JsonProperty(value="primaryKey")
    private String primaryKey;

    @JsonCreator
    public PostgresLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="url") String url, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="primaryKey") String primaryKey) {
        super(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties);
        this.url = Preconditions.checkNotNull(url, "url is null");
        this.username = Preconditions.checkNotNull(username, "username is null");
        this.password = Preconditions.checkNotNull(password, "password is null");
        this.tableName = Preconditions.checkNotNull(tableName, "tableName is null");
        this.primaryKey = primaryKey;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put("connector", "jdbc-inlong");
        options.put("dialect-impl", "org.apache.inlong.sort.jdbc.dialect.PostgresDialect");
        options.put("url", this.url);
        options.put("username", this.username);
        options.put("password", this.password);
        options.put("table-name", this.tableName);
        return options;
    }

    @Override
    public String genTableName() {
        return String.format("table_%s", super.getId());
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostgresLoadNode)) {
            return false;
        }
        PostgresLoadNode other = (PostgresLoadNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PostgresLoadNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public String toString() {
        return "PostgresLoadNode(url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", tableName=" + this.getTableName() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    public PostgresLoadNode() {
    }
}

