/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flume.CounterGroup;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.FlumeConfiguration;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.flume.node.AbstractConfigurationProvider;
import org.apache.flume.node.ConfigurationSource;
import org.apache.flume.node.MapResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriConfigurationProvider
extends AbstractConfigurationProvider
implements LifecycleAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(UriConfigurationProvider.class);
    private final List<ConfigurationSource> configurationSources;
    private final File backupDirectory;
    private final EventBus eventBus;
    private final int interval;
    private final CounterGroup counterGroup;
    private LifecycleState lifecycleState = LifecycleState.IDLE;
    private ScheduledExecutorService executorService;

    public UriConfigurationProvider(String agentName, List<ConfigurationSource> sourceList, String backupDirectory, EventBus eventBus, int pollInterval) {
        super(agentName);
        this.configurationSources = sourceList;
        this.backupDirectory = backupDirectory != null ? new File(backupDirectory) : null;
        this.eventBus = eventBus;
        this.interval = pollInterval;
        this.counterGroup = new CounterGroup();
    }

    public void start() {
        if (this.eventBus != null && this.interval > 0) {
            this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("conf-file-poller-%d").build());
            WatcherRunnable watcherRunnable = new WatcherRunnable(this.configurationSources, this.counterGroup, this.eventBus);
            this.executorService.scheduleWithFixedDelay(watcherRunnable, 0L, this.interval, TimeUnit.SECONDS);
        }
        this.lifecycleState = LifecycleState.START;
    }

    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                    LOGGER.debug("File watcher has not terminated. Forcing shutdown of executor.");
                    this.executorService.shutdownNow();
                    while (!this.executorService.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                        LOGGER.debug("Waiting for file watcher to terminate");
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.debug("Interrupted while waiting for file watcher to terminate");
                Thread.currentThread().interrupt();
            }
        }
        this.lifecycleState = LifecycleState.STOP;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    protected List<ConfigurationSource> getConfigurationSources() {
        return this.configurationSources;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FlumeConfiguration getFlumeConfiguration() {
        configMap = null;
        properties = new Properties();
        for (ConfigurationSource configurationSource : this.configurationSources) {
            block57: {
                try {
                    is = configurationSource.getInputStream();
                    var6_9 = null;
                    try {
                        if (is == null) break block57;
                        var7_10 = configurationSource.getExtension();
                        var8_17 = -1;
                        switch (var7_10.hashCode()) {
                            case 3271912: {
                                if (!var7_10.equals("json")) break;
                                var8_17 = 0;
                                break;
                            }
                            case 3701415: {
                                if (!var7_10.equals("yaml")) break;
                                var8_17 = 1;
                                break;
                            }
                            case 118807: {
                                if (!var7_10.equals("xml")) break;
                                var8_17 = 2;
                            }
                        }
                        switch (var8_17) {
                            case 0: 
                            case 1: 
                            case 2: {
                                UriConfigurationProvider.LOGGER.warn("File extension type {} is unsupported", (Object)configurationSource.getExtension());
                                ** break;
lbl27:
                                // 1 sources

                                break;
                            }
                            default: {
                                properties.load(is);
                                break;
                            }
                        }
                    }
                    catch (Throwable var7_12) {
                        var6_9 = var7_12;
                        throw var7_12;
                    }
                    finally {
                        if (is != null) {
                            if (var6_9 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable var7_11) {
                                    var6_9.addSuppressed(var7_11);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    UriConfigurationProvider.LOGGER.warn("Unable to load properties from {}: {}", (Object)configurationSource.getUri(), (Object)ioe.getMessage());
                }
            }
            if (properties.size() <= 0) continue;
            configMap = MapResolver.resolveProperties(properties);
        }
        if (configMap != null) {
            props = new Properties();
            props.putAll(configMap);
            if (this.backupDirectory != null) {
                if (this.backupDirectory.mkdirs()) {
                    UriConfigurationProvider.LOGGER.debug("Created directories for {}", (Object)this.backupDirectory.toString());
                }
                backupFile = this.getBackupFile(this.backupDirectory, this.getAgentName());
                try {
                    os = new FileOutputStream(backupFile);
                    var6_9 = null;
                    try {
                        props.store(os, "Backup created at " + LocalDateTime.now().toString());
                    }
                    catch (Throwable var7_14) {
                        var6_9 = var7_14;
                        throw var7_14;
                    }
                    finally {
                        if (os != null) {
                            if (var6_9 != null) {
                                try {
                                    os.close();
                                }
                                catch (Throwable var7_13) {
                                    var6_9.addSuppressed(var7_13);
                                }
                            } else {
                                os.close();
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    UriConfigurationProvider.LOGGER.warn("Unable to create backup properties file: {}" + ioe.getMessage());
                }
            }
        } else if (this.backupDirectory != null && (backup = this.getBackupFile(this.backupDirectory, this.getAgentName())).exists()) {
            props = new Properties();
            try {
                is = new FileInputStream(backup);
                var6_9 = null;
                try {
                    UriConfigurationProvider.LOGGER.warn("Unable to access primary configuration. Trying backup");
                    props.load(is);
                    configMap = MapResolver.resolveProperties(props);
                }
                catch (Throwable var7_16) {
                    var6_9 = var7_16;
                    throw var7_16;
                }
                finally {
                    if (is != null) {
                        if (var6_9 != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable var7_15) {
                                var6_9.addSuppressed(var7_15);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                UriConfigurationProvider.LOGGER.warn("Error reading backup file: {}", (Object)ex.getMessage());
            }
        }
        if (configMap != null) {
            return new FlumeConfiguration(configMap);
        }
        UriConfigurationProvider.LOGGER.error("No configuration could be found");
        return null;
    }

    private File getBackupFile(File backupDirectory, String agentName) {
        if (backupDirectory != null) {
            return new File(backupDirectory, "." + agentName + ".properties");
        }
        return null;
    }

    private class WatcherRunnable
    implements Runnable {
        private List<ConfigurationSource> configurationSources;
        private final CounterGroup counterGroup;
        private final EventBus eventBus;

        public WatcherRunnable(List<ConfigurationSource> sources, CounterGroup counterGroup, EventBus eventBus) {
            this.configurationSources = sources;
            this.counterGroup = counterGroup;
            this.eventBus = eventBus;
        }

        @Override
        public void run() {
            LOGGER.debug("Checking for changes to sources");
            this.counterGroup.incrementAndGet("uri.checks");
            try {
                boolean isModified = false;
                for (ConfigurationSource source : this.configurationSources) {
                    if (!source.isModified()) continue;
                    isModified = true;
                }
                if (isModified) {
                    this.eventBus.post((Object)UriConfigurationProvider.this.getConfiguration());
                }
            }
            catch (ConfigurationException ex) {
                LOGGER.warn("Unable to update configuration: {}", (Object)ex.getMessage());
            }
        }
    }
}

