/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.ddl;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;
import org.apache.flink.sql.parser.hive.impl.ParseException;

public class SqlAlterHivePartitionRename
extends SqlAlterTable {
    private final SqlNodeList newPartSpec;

    public SqlAlterHivePartitionRename(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList partSpec, SqlNodeList newPartSpec) throws ParseException {
        super(pos, tableName, partSpec);
        if (partSpec == null || newPartSpec == null) {
            throw new ParseException("Both old and new partition spec have to be specified");
        }
        HiveDDLUtils.unescapePartitionSpec(partSpec);
        HiveDDLUtils.unescapePartitionSpec(newPartSpec);
        this.newPartSpec = newPartSpec;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tableIdentifier, this.getPartitionSpec(), this.newPartSpec);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.newlineAndIndent();
        writer.keyword("RENAME TO");
        writer.newlineAndIndent();
        writer.keyword("PARTITION");
        this.newPartSpec.unparse(writer, this.getOperator().getLeftPrec(), this.getOperator().getRightPrec());
    }

    public SqlNodeList getNewPartSpec() {
        return this.newPartSpec;
    }
}

