/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.ddl;

import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ddl.SqlCreateView;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;
import org.apache.flink.table.factories.FactoryUtil;

public class SqlCreateHiveView
extends SqlCreateView {
    private SqlNodeList originPropList;

    public SqlCreateHiveView(SqlParserPos pos, SqlIdentifier viewName, SqlNodeList fieldList, SqlNode query, boolean ifNotExists, SqlCharStringLiteral comment, SqlNodeList properties) {
        super(pos, viewName, fieldList, query, false, false, ifNotExists, HiveDDLUtils.unescapeStringLiteral(comment), properties);
        HiveDDLUtils.unescapeProperties(properties);
        this.originPropList = new SqlNodeList(properties.getList(), properties.getParserPosition());
        properties.add(HiveDDLUtils.toTableOption(FactoryUtil.CONNECTOR.key(), "hive", pos));
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE VIEW");
        if (this.isIfNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        this.getViewName().unparse(writer, leftPrec, rightPrec);
        if (this.getFieldList().size() > 0) {
            this.getFieldList().unparse(writer, 1, rightPrec);
        }
        this.getComment().ifPresent(c -> {
            writer.newlineAndIndent();
            writer.keyword("COMMENT");
            c.unparse(writer, leftPrec, rightPrec);
        });
        if (this.originPropList.size() > 0) {
            writer.newlineAndIndent();
            writer.keyword("TBLPROPERTIES");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.originPropList) {
                this.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
        writer.newlineAndIndent();
        writer.keyword("AS");
        writer.newlineAndIndent();
        this.getQuery().unparse(writer, leftPrec, rightPrec);
    }
}

