/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.math.BigDecimal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;

public abstract class AvgAggFunction
extends DeclarativeAggregateFunction {
    private final UnresolvedReferenceExpression sum = ApiExpressionUtils.unresolvedRef((String)"sum");
    private final UnresolvedReferenceExpression count = ApiExpressionUtils.unresolvedRef((String)"count");

    public abstract DataType getSumType();

    @Override
    public int operandCount() {
        return 1;
    }

    @Override
    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.sum, this.count};
    }

    @Override
    public DataType[] getAggBufferTypes() {
        return new DataType[]{this.getSumType(), DataTypes.BIGINT()};
    }

    @Override
    public Expression[] initialValuesExpressions() {
        return new Expression[]{ExpressionBuilder.literal(0L, (DataType)this.getSumType().notNull()), ExpressionBuilder.literal(0L)};
    }

    @Override
    public Expression[] accumulateExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.sum, (Expression)this.adjustedPlus(this.sum, this.operand(0))), ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.count, (Expression)ExpressionBuilder.plus((Expression)this.count, (Expression)ExpressionBuilder.literal(1L)))};
    }

    @Override
    public Expression[] retractExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.sum, (Expression)this.adjustedMinus(this.sum, this.operand(0))), ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.count, (Expression)ExpressionBuilder.minus((Expression)this.count, (Expression)ExpressionBuilder.literal(1L)))};
    }

    @Override
    public Expression[] mergeExpressions() {
        return new Expression[]{this.adjustedPlus(this.sum, this.mergeOperand(this.sum)), ExpressionBuilder.plus((Expression)this.count, (Expression)this.mergeOperand(this.count))};
    }

    @Override
    public Expression getValueExpression() {
        ValueLiteralExpression ifTrue = ExpressionBuilder.nullOf(this.getResultType());
        UnresolvedCallExpression ifFalse = ExpressionBuilder.cast((Expression)ExpressionBuilder.div((Expression)this.sum, (Expression)this.count), (Expression)ExpressionBuilder.typeLiteral(this.getResultType()));
        return ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.equalTo((Expression)this.count, (Expression)ExpressionBuilder.literal(0L)), (Expression)ifTrue, (Expression)ifFalse);
    }

    protected UnresolvedCallExpression adjustedPlus(UnresolvedReferenceExpression arg1, UnresolvedReferenceExpression arg2) {
        return ExpressionBuilder.plus((Expression)arg1, (Expression)arg2);
    }

    protected UnresolvedCallExpression adjustedMinus(UnresolvedReferenceExpression arg1, UnresolvedReferenceExpression arg2) {
        return ExpressionBuilder.minus((Expression)arg1, (Expression)arg2);
    }

    public static class DecimalAvgAggFunction
    extends AvgAggFunction {
        private final DataType resultType;
        private final DataType sumResultType;

        public DecimalAvgAggFunction(DecimalType type) {
            DecimalType t = (DecimalType)LogicalTypeMerging.findAvgAggType((LogicalType)type);
            this.resultType = DataTypes.DECIMAL((int)t.getPrecision(), (int)t.getScale());
            t = (DecimalType)LogicalTypeMerging.findSumAggType((LogicalType)type);
            this.sumResultType = DataTypes.DECIMAL((int)t.getPrecision(), (int)t.getScale());
        }

        @Override
        public DataType getResultType() {
            return this.resultType;
        }

        @Override
        public DataType getSumType() {
            return this.sumResultType;
        }

        @Override
        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(BigDecimal.ZERO, (DataType)this.getSumType().notNull()), ExpressionBuilder.literal(0L)};
        }

        @Override
        protected UnresolvedCallExpression adjustedPlus(UnresolvedReferenceExpression arg1, UnresolvedReferenceExpression arg2) {
            return ExpressionBuilder.aggDecimalPlus((Expression)arg1, (Expression)arg2);
        }

        @Override
        protected UnresolvedCallExpression adjustedMinus(UnresolvedReferenceExpression arg1, UnresolvedReferenceExpression arg2) {
            return ExpressionBuilder.aggDecimalMinus((Expression)arg1, (Expression)arg2);
        }
    }

    public static class DoubleAvgAggFunction
    extends AvgAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.DOUBLE();
        }

        @Override
        public DataType getSumType() {
            return DataTypes.DOUBLE();
        }

        @Override
        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(0.0), ExpressionBuilder.literal(0L)};
        }
    }

    public static class FloatAvgAggFunction
    extends AvgAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.FLOAT();
        }

        @Override
        public DataType getSumType() {
            return DataTypes.DOUBLE();
        }

        @Override
        public Expression[] initialValuesExpressions() {
            return new Expression[]{ExpressionBuilder.literal(0.0), ExpressionBuilder.literal(0L)};
        }
    }

    public static class LongAvgAggFunction
    extends AvgAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.BIGINT();
        }

        @Override
        public DataType getSumType() {
            return DataTypes.BIGINT();
        }
    }

    public static class IntAvgAggFunction
    extends AvgAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.INT();
        }

        @Override
        public DataType getSumType() {
            return DataTypes.BIGINT();
        }
    }

    public static class ShortAvgAggFunction
    extends AvgAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.SMALLINT();
        }

        @Override
        public DataType getSumType() {
            return DataTypes.BIGINT();
        }
    }

    public static class ByteAvgAggFunction
    extends AvgAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.TINYINT();
        }

        @Override
        public DataType getSumType() {
            return DataTypes.BIGINT();
        }
    }
}

