/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.lang.reflect.Method;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractCharacterFamilyTargetRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.VarCharType;

class IntervalToStringCastRule
extends AbstractCharacterFamilyTargetRule<Object> {
    static final IntervalToStringCastRule INSTANCE = new IntervalToStringCastRule();

    private IntervalToStringCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeFamily.INTERVAL).target((LogicalType)VarCharType.STRING_TYPE).build());
    }

    @Override
    public String generateStringExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        Method method = inputLogicalType.is(LogicalTypeRoot.INTERVAL_YEAR_MONTH) ? BuiltInMethods.INTERVAL_YEAR_MONTH_TO_STRING() : BuiltInMethods.INTERVAL_DAY_TIME_TO_STRING();
        return CastRuleUtils.staticCall(method, inputTerm);
    }
}

