/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.functions.casting.AbstractNullAwareCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastCodeBlock;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleProvider;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

class RowToRowCastRule
extends AbstractNullAwareCodeGeneratorCastRule<RowData, RowData> {
    static final RowToRowCastRule INSTANCE = new RowToRowCastRule();

    private RowToRowCastRule() {
        super(CastRulePredicate.builder().predicate(RowToRowCastRule::matches).build());
    }

    private static boolean matches(LogicalType input, LogicalType target) {
        if (!input.is(LogicalTypeRoot.ROW) && !input.is(LogicalTypeRoot.STRUCTURED_TYPE) || !target.is(LogicalTypeRoot.ROW) && !target.is(LogicalTypeRoot.STRUCTURED_TYPE)) {
            return false;
        }
        List inputFields = LogicalTypeChecks.getFieldTypes((LogicalType)input);
        List targetFields = LogicalTypeChecks.getFieldTypes((LogicalType)target);
        if (inputFields.size() < targetFields.size()) {
            return false;
        }
        return IntStream.range(0, targetFields.size()).allMatch(i -> CastRuleProvider.exists((LogicalType)inputFields.get(i), (LogicalType)targetFields.get(i)));
    }

    @Override
    protected String generateCodeBlockInternal(CodeGeneratorCastRule.Context context, String inputTerm, String returnVariable, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        List inputFields = LogicalTypeChecks.getFieldTypes((LogicalType)inputLogicalType);
        List targetFields = LogicalTypeChecks.getFieldTypes((LogicalType)targetLogicalType);
        String rowTerm = CodeGenUtils.newName("row");
        String writerTerm = CodeGenUtils.newName("writer");
        context.declareClassField(CodeGenUtils.className(BinaryRowData.class), rowTerm, CastRuleUtils.constructorCall(BinaryRowData.class, inputFields.size()));
        context.declareClassField(CodeGenUtils.className(BinaryRowWriter.class), writerTerm, CastRuleUtils.constructorCall(BinaryRowWriter.class, rowTerm));
        CastRuleUtils.CodeWriter writer = new CastRuleUtils.CodeWriter().stmt(CastRuleUtils.methodCall(writerTerm, "reset", new Object[0]));
        for (int i = 0; i < targetFields.size(); ++i) {
            LogicalType inputFieldType = (LogicalType)inputFields.get(i);
            LogicalType targetFieldType = (LogicalType)targetFields.get(i);
            String indexTerm = String.valueOf(i);
            String fieldTerm = CodeGenUtils.newName("f" + indexTerm + "Value");
            String fieldIsNullTerm = CodeGenUtils.newName("f" + indexTerm + "IsNull");
            CastCodeBlock codeBlock = CastRuleProvider.generateAlwaysNonNullCodeBlock(context, fieldTerm, inputFieldType, targetFieldType);
            String readField = CodeGenUtils.rowFieldReadAccess(indexTerm, inputTerm, inputFieldType);
            String writeField = CastRuleUtils.binaryWriterWriteField(context, writerTerm, targetFieldType, indexTerm, codeBlock.getReturnTerm());
            String writeNull = CastRuleUtils.binaryWriterWriteNull(writerTerm, targetFieldType, indexTerm);
            writer.declStmt(Boolean.TYPE, fieldIsNullTerm, CastRuleUtils.methodCall(inputTerm, "isNullAt", indexTerm)).ifStmt("!" + fieldIsNullTerm, thenBodyWriter -> thenBodyWriter.declPrimitiveStmt(inputFieldType, fieldTerm, readField).append(codeBlock).ifStmt("!" + codeBlock.getIsNullTerm(), thenCastResultWriter -> thenCastResultWriter.stmt(writeField), elseCastResultWriter -> elseCastResultWriter.stmt(writeNull)), elseBodyWriter -> elseBodyWriter.stmt(writeNull));
        }
        writer.stmt(CastRuleUtils.methodCall(writerTerm, "complete", new Object[0])).assignStmt(returnVariable, rowTerm);
        return writer.toString();
    }

    @Override
    public boolean canFail(LogicalType inputLogicalType, LogicalType targetLogicalType) {
        List inputFields = LogicalTypeChecks.getFieldTypes((LogicalType)inputLogicalType);
        List targetFields = LogicalTypeChecks.getFieldTypes((LogicalType)targetLogicalType);
        return IntStream.range(0, Math.min(inputFields.size(), targetFields.size())).anyMatch(i -> CastRuleProvider.canFail((LogicalType)inputFields.get(i), (LogicalType)targetFields.get(i)));
    }
}

